/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lib.uno.helper.MultiTypeInterfaceContainer;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.Type;

public class ComponentBase
extends WeakBase
implements XComponent {
    private final boolean DEBUG;
    protected MultiTypeInterfaceContainer listenerContainer;
    protected boolean bInDispose;
    protected boolean bDisposed;
    static final Type EVT_LISTENER_TYPE = new Type(ComponentBase.class$("com.sun.star.lang.XEventListener"));

    private /* synthetic */ void finit$() {
        this.DEBUG = false;
        this.bInDispose = false;
        this.bDisposed = false;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ComponentBase() {
        this.finit$();
        this.listenerContainer = new MultiTypeInterfaceContainer();
    }

    protected void preDisposing() {
    }

    protected void postDisposing() {
    }

    public void dispose() {
        Object var3_3;
        boolean bl = false;
        ComponentBase componentBase = this;
        synchronized (componentBase) {
            block9: {
                try {
                    if (this.bInDispose || this.bDisposed) break block9;
                    bl = true;
                    this.bInDispose = true;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
            var3_3 = null;
        }
        if (bl) {
            try {
                this.preDisposing();
                this.listenerContainer.disposeAndClear(new EventObject(this));
                this.postDisposing();
            }
            finally {
                var3_3 = null;
                this.bDisposed = true;
                this.bInDispose = false;
            }
        } else if (this.DEBUG) {
            System.out.println("OComponentHelper::dispose() - dispose called twice");
        }
    }

    public void removeEventListener(XEventListener xEventListener) {
        this.listenerContainer.removeInterface(EVT_LISTENER_TYPE, xEventListener);
    }

    public void addEventListener(XEventListener xEventListener) {
        boolean bl = false;
        ComponentBase componentBase = this;
        synchronized (componentBase) {
            block5: {
                try {
                    if (this.bDisposed || this.bInDispose) {
                        bl = true;
                        break block5;
                    }
                    this.listenerContainer.addInterface(EVT_LISTENER_TYPE, xEventListener);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
            Object var4_4 = null;
        }
        if (bl) {
            xEventListener.disposing(new EventObject(this));
        }
    }

    protected void finalize() throws Throwable {
        if (!this.bInDispose && !this.bDisposed) {
            this.dispose();
        }
        super.finalize();
    }
}

