from OFS.content_types import guess_content_type
import string

try:
  import kinterbasdb
except:
  pass
try:
  import psycopg
except:
  pass

def _medebug( val ):
	import os
	from Globals import package_home
	package_path = package_home(globals())

	fp = open(os.path.join(package_path ,'debug.txt'), 'a')
	fp.write('\n')
	fp.write(val)
	fp.write('\n--------------\n')
	fp.close()

def _insertIbSQL(constr, mid, pid, ptype, pic, contenttype):
    """
    """
    mid = int(mid)
    pid = int(pid)

    try:
      a_dsn, a_user, a_pass, a_charset = string.split(constr)
      con = kinterbasdb.connect(dsn=a_dsn, user=a_user, password=a_pass, charset=a_charset)
      cur = con.cursor()


      # inc imgid:
      cur.execute("select gen_id(imgid_gen, 1) from rdb$database")
      imgid = cur.fetchone()[0]
      

      sqlst = """insert into imgbbsblob values (?, ?, ?, ?, ?, ?) """
      cur.execute(sqlst, (imgid, mid, pid, ptype, pic, contenttype))
      con.commit()
    except:
      con.rollback()

def _insertPgSQL(constr, mid, pid, ptype, pic, contenttype):
    """
    """
    mid = int(mid)
    pid = int(pid)


    try:
      con = psycopg.connect(constr)
      cur = con.cursor()

      cur.execute("""INSERT INTO imgbbsblob (mid, pid, ptype, pic,contenttype)
       VALUES (%(mid)d,%(pid)d,%(ptype)s,%(pic)s,%(contenttype)s)""",
       {'mid':mid,
       'pid':pid,
       'ptype':ptype,
        'pic':psycopg.Binary(pic),
	'contenttype':contenttype
        })
      con.commit()

    except:
      con.rollback()


def _updateIbSQL(constr, imgid, mid, pid, ptype,  pic, contenttype):
    """
    """
    imgid = int(imgid)
    mid = int(mid)
    pid = int(pid)
    try:
      a_dsn, a_user, a_pass, a_charset = string.split(constr)
      con = kinterbasdb.connect(dsn=a_dsn, user=a_user, password=a_pass, charset=a_charset)
      cur = con.cursor()
      sqlst = """update imgbbsblob set mid=?, pid=?, ptype=?, pic=?, contenttype=? where(imgid=?)"""
      cur.execute(sqlst, (mid, pid, pic, ptype, contenttype, imgid))
      con.commit()
    except:
      con.rollback()

def _updatePgSQL(constr, imgid, mid, pid, ptype,  pic, contenttype):
    """
    """
    imgid = int(imgid)
    mid = int(mid)
    pid = int(pid)
    try:
      con = psycopg.connect(constr)
      cur = con.cursor()
      sqlst = """update imgbbsblob set mid=%(mid)d,pid=%(pid)d,
       ptype=%(ptype)s, pic=%(pic)s,
       contenttype=%(contenttype)s
          where (imgid=%(imgid)d) """
      cur.execute(sqlst,{
          'mid':mid,
	  'pid':pid,
	  'ptype':ptype,
	  'pic':psycopg.Binary(pic),
	  'contenttype':contenttype,
	  'imgid':imgid})
      con.commit()
    except:
      con.rollback()
