#############################
#  pykf+jananeseCodecs
#  pykf ϡAtsuo Ishimoto
#  jplib Matsumoto Tadashi 
#  kconvϳỳ
#  is_euc_1,is_sjis_1, get_string_part 
#Atsushi ShibataCOREBlog utility.py
# 餽줾ѵڤҼڤޤ
# äƥ饤󥹤ϤΥ饤
# Ѥޤ
#
# Copy right(c) 2003/11/20
#   Kiyoharu Ueno (kiyo@yosiki.jp)
#     demo convert utf-8, shift_jis, euc_jp
#############################
"""encode convert"""
__version__="0.1"

def _jplibconv(st, defconv):
    """
    """
    rets = None

    try:
      import jplib
      if defconv == 'euc-jp':
        rets = jplib.euc(st)
      elif defconv == 'shift_jis':
        rets = jplib.sjis(st)
      elif defconv == 'utf-8':
        rets = jplib.utf8(st)
    except:
      pass

    return rets

def _pykfconv(st, defconv):
    """
    """
    rets = None

    try:
        import pykf

	if defconv == 'euc-jp':
	  rets = pykf.toeuc(st)
	elif defconv == 'shift_jis':
	  rets = pykf.tosjis(st)
	elif defconv == 'utf-8':
	  defcode = pykf.guess(st)
	  if defcode == pykf.EUC:
	    rets=unicode(st, "japanese.euc-jp","replace").encode('utf-8')
	  elif defcode==pykf.SJIS:
	    rets=unicode(st, "japanese.shift_jis","replace").encode('utf-8')
    except:
        pass

    return rets

def _kconvconv(st, defcov):
    """
    """
    rets = None

    try:
        import kconv
	if defconv == 'euc-jp':
	  rets = kconv.Kconv(kconv.EUC).convert(st)
	elif defconv == 'shift_jis':
	  rets = kconv.Kconv(kconv.SJIS).convert(st)
	elif defconv == 'utf-8':
	  rets = kconv.Kconv(kconv.UTF8).convert(st)
    except:
        pass
    return rets

def conv(st, conv_code):
    """
    """
    if conv_code:
      defconv = conv_code
    else:
      return st

    rets =  _pykfconv(st, defconv)
    if not rets:
       rets = _jplibconv(st, defconv)
       if not rets:
         rets = _kconvconv(st, defconv)
         if not rets:
           rets = st

    return rets

###########################
# form owa(shu konno)
# change kiyo
###########################
def utf8string(s, cols):
    size = len(s)
    cpos = 0
    bytes = 0
    while (cols > 0) and (cpos < size):
        c = ord(s[cpos])
        if (c & 0xe0) == 0xe0:
            bytes = 3
            cols -= 2
        elif (c & 0xe0) == 0xc0:
            bytes = 2
            cols -= 1 # ȤΤʤ?
        else:
            bytes = 1
            cols -= 1

        cpos += bytes

    if (cols < 0) or (cpos > size):
        cpos -= bytes

    return s[:cpos]


###############################################
# from COREBlog utility.py
# Copyright (c) 2003 Atsushi Shibata(shibata@webcore.co.jp)
###############################################


def is_euc_1(buff,pos):
    st = 0 # 0:ascii 1:euc1
    for pos in range(0,pos):
        if 0xa1 <= ord(buff[pos]) <= 0xfe:
            if st == -1:
                st = 0
            st = (st + 1) % 2
        else:
            st = -1
    ret = 0
    if st == -1:
        ret = 0
    elif st == 1:
        ret = 1

    return ret


def is_sjis_1(buff,pos):
    if (ord(buff[pos]) >= 0x81 and ord(buff[pos]) <= 0x9f) or \
       (ord(buff[pos]) >= 0xe0 and ord(buff[pos]) <= 0xff):
       return 1
    return 0


def get_string_part(str,length,codestr):
    # return string in certain range(consider Japanese 2byte codes).
    ret_str = str
    if len(str) > length:
        if codestr == 'euc-jp':
            if is_euc_1(str,length) == 1:
                length = length - 1
            ret_str = str[:length]
        elif codestr == 'shift_jis':
            if is_sjis_1(str,length+1):
                length = length - 1
            ret_str = str[:length]
        elif codestr == 'utf-8':
	    try:
              ret_str = utf8string(str,length)
	    except:
	      pass
        else:
            ret_str = str[:length]
    return ret_str
