/*
 * $Id: HttpConnectionImpl.java,v 1.2 2002/05/03 14:33:32 ymakise Exp $
 */

/*
 * ΥեΥ饤󥹤ϰʲΤ褦 BSD 饤󥹤˽򤷤ޤ
 * 㳰ȤơiɤѴġˤäѴ줿Ѵ
 *  MIDP ץꥱղä줿󥿥饤֥ΥХʥ
 * ˤĤƤϡiɤԤϤʤ븢ĥʤΤȤޤ
 *
 * Copyright (c) 2002, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.nttdocomo.io;

import java.io.*;

/*


  javax.microedition.io.HttpConnection Ȥޤˤ㤤ʤΤ
  ˤäʤäѤץѴǽȤ

  - com.nttdocomo.io.HttpConnection ؤλȤ
    javax.microedition.io.HttpConnection Ѵ
  - disconnect() ؤθƤӽФ getResponseCode() θƤӽФѴ
  - getHeaderField(), getDate(), getExpiration(), getLastModified(),
    setIfModifiedSince() ϥإѥ롼ѰդƤƤؤ
    ƤӽФѴ
 */

public class HttpConnectionImpl implements HttpConnection {
    private javax.microedition.io.HttpConnection m_conn;

    public HttpConnectionImpl(javax.microedition.io.HttpConnection conn) {
        m_conn = conn;
    }

    public void connect() throws IOException {
        /* ³ɬפʥ᥽åɤƤǡŪ³ */
        m_conn.getResponseCode();
    }

    public void close() throws IOException {
        m_conn.close();
    }

    public InputStream openInputStream() throws IOException {
        return m_conn.openInputStream();
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        return m_conn.openOutputStream();
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(openOutputStream());
    }

    public String getEncoding() {
        return m_conn.getEncoding();
    }

    public long getLength() {
        return m_conn.getLength();
    }

    public String getType() {
        return m_conn.getType();
    }

    public String getURL() {
        return m_conn.getURL();
    }

    public void setRequestMethod(String method) throws IOException {
        m_conn.setRequestMethod(method);
    }

    public void setRequestProperty(String key, String value) throws IOException {
        m_conn.setRequestProperty(key, value);
    }

    public int getResponseCode() throws IOException {
        return m_conn.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return m_conn.getResponseMessage();
    }

    public String getHeaderField(String name) {
        try {
            return m_conn.getHeaderField(name);
        } catch (IOException ioe) {
            /* 褦Τ connect() ᥽åɤƤ
               Υ᥽åɤƤȤ */
            throw new RuntimeException();
        }
    }

    public long getDate() {
        try {
            return m_conn.getDate();
        } catch (IOException ioe) {
            /* 褦Τ connect() ᥽åɤƤ
               Υ᥽åɤƤȤ */
            throw new RuntimeException();
        }
    }

    public long getExpiration() {
        try {
            return m_conn.getExpiration();
        } catch (IOException ioe) {
            /* 褦Τ connect() ᥽åɤƤ
               Υ᥽åɤƤȤ */
            throw new RuntimeException();
        }
    }

    public long getLastModified() {
        try {
            return m_conn.getLastModified();
        } catch (IOException ioe) {
            /* 褦Τ connect() ᥽åɤƤ
               Υ᥽åɤƤȤ */
            throw new RuntimeException();
        }
    }

    public void setIfModifiedSince(long ifmodifiedsince) {
        /* PENDING: ॹפʸ󲽽Ϥǽ񤫤ʤ
           ʤΤα */
//         try {
//             m_conn.setRequestProperty("If-Modified-Since",
//                                       "29 Oct 1999 19:43:31 GMT");
//         } catch (IOException ioe) {
//             /* 褦Τ connect() ᥽åɤƤ
//                Υ᥽åɤƤȤ */
//             throw new RuntimeException();
//         }
    }
}
