/*
 * $Id: Font.java,v 1.2 2002/05/03 14:33:39 ymakise Exp $
 */

/*
 * ΥեΥ饤󥹤ϰʲΤ褦 BSD 饤󥹤˽򤷤ޤ
 * 㳰ȤơiɤѴġˤäѴ줿Ѵ
 *  MIDP ץꥱղä줿󥿥饤֥ΥХʥ
 * ˤĤƤϡiɤԤϤʤ븢ĥʤΤȤޤ
 *
 * Copyright (c) 2002, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.nttdocomo.ui;

public class Font {
    public static final int TYPE_DEFAULT      = 0x00000000;
    public static final int TYPE_HEADING      = 0x00000001;
    public static final int FACE_SYSTEM       = 0x71000000;
    public static final int FACE_MONOSPACE    = 0x72000000;
    public static final int FACE_PROPORTIONAL = 0x73000000;
    public static final int STYLE_PLAIN       = 0x70100000;
    public static final int STYLE_BOLD        = 0x70110000;
    public static final int STYLE_ITALIC      = 0x70120000;
    public static final int STYLE_BOLDITALIC  = 0x70130000;
    public static final int SIZE_SMALL        = 0x70000100;
    public static final int SIZE_MEDIUM       = 0x70000200;
    public static final int SIZE_LARGE        = 0x70000300;

    private javax.microedition.lcdui.Font m_font;
        
    private static final int[] FACES = {
        javax.microedition.lcdui.Font.FACE_SYSTEM,
        javax.microedition.lcdui.Font.FACE_SYSTEM,
        javax.microedition.lcdui.Font.FACE_MONOSPACE,
        javax.microedition.lcdui.Font.FACE_PROPORTIONAL
    };

    private static final int[] STYLES = {
        javax.microedition.lcdui.Font.STYLE_PLAIN,
        javax.microedition.lcdui.Font.STYLE_BOLD,
        javax.microedition.lcdui.Font.STYLE_ITALIC,
        (javax.microedition.lcdui.Font.STYLE_BOLD |
         javax.microedition.lcdui.Font.STYLE_ITALIC)
    };

    private static final int[] SIZES = {
        javax.microedition.lcdui.Font.SIZE_MEDIUM,
        javax.microedition.lcdui.Font.SIZE_SMALL,
        javax.microedition.lcdui.Font.SIZE_MEDIUM,
        javax.microedition.lcdui.Font.SIZE_LARGE
    };

    private Font(javax.microedition.lcdui.Font font) {
        m_font = font;
    }

    javax.microedition.lcdui.Font getMIDPFont() {
        return m_font;
    }

    public static Font getFont(int type) {
        if ((type & 0xf0000000) == 0x0000000) {
            if (type == TYPE_HEADING)
                type = FACE_SYSTEM | STYLE_BOLD | SIZE_MEDIUM;
            else        /* TYPE_DEFAULT, and others */
                type = FACE_SYSTEM | STYLE_PLAIN | SIZE_MEDIUM;
        }

        int face  = FACES[(type >> 24) & 0x03];
        int style = STYLES[(type >> 16) & 0x03];
        int size  = SIZES[(type >> 8) & 0x03];

        return new Font(javax.microedition.lcdui.Font.getFont(face, style, size));
    }

    public static Font getDefaultFont() {
        return getFont(TYPE_DEFAULT);
    }

    public int getAscent() {
        return m_font.getBaselinePosition();
    }

    public int getDescent() {
        return getHeight() - getAscent();
    }

    public int getHeight() {
        return m_font.getHeight();
    }

    public int stringWidth(String str) {
        return m_font.stringWidth(str);
    }

    public int getBBoxWidth(String str) {
        return stringWidth(str);
    }

    public int getBBoxHeight(String str) {
        return getHeight();
    }

    public int getLineBreak(String str, int off, int len, int width) {
        for (int i = off; i < off + len; i++) {
            String s = str.substring(off, i + 1);
            if (m_font.stringWidth(s) > width)
                return i;
        }

        return off + len;
    }
}
