/*
 * $Id: ScratchPadOutputStream.java,v 1.2 2002/05/03 14:34:14 ymakise Exp $
 */

/*
 * ΥեΥ饤󥹤ϰʲΤ褦 BSD 饤󥹤˽򤷤ޤ
 * 㳰ȤơiɤѴġˤäѴ줿Ѵ
 *  MIDP ץꥱղä줿󥿥饤֥ΥХʥ
 * ˤĤƤϡiɤԤϤʤ븢ĥʤΤȤޤ
 *
 * Copyright (c) 2002, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package imodoki.wrapper;

import java.io.*;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

/**
 * åѥåɤؤνϤ¸륯饹
 */
class ScratchPadOutputStream extends ByteArrayOutputStream {
    private int m_offset;

    /* ƥ饹Ѿ줿ե: buf, count */

    public ScratchPadOutputStream(int offset) {
        super();
        m_offset = offset;
    }

    public void close() throws IOException {
        super.close();

        /* 쥳ɥȥؤν񤭹 */
        try {
            RecordStore rs = RecordStore.openRecordStore("R", true);

            /* 쥳ɤ¸Ǥʤ˺ */
            if (rs.getNumRecords() == 0) {
                rs.addRecord(new byte[0], 0, 0);
            }
            byte[] newbuf = new byte[Math.max(rs.getRecordSize(1),
                                              m_offset + this.count)];
            rs.getRecord(1, newbuf, 0);
            System.arraycopy(this.buf, 0, newbuf, m_offset, this.count);
            rs.setRecord(1, newbuf, 0, newbuf.length);

            rs.closeRecordStore();
        } catch (RecordStoreException rse) {
            throw new IOException();
        }
    }
}
