import com.nttdocomo.ui.*;

public class MediaImageTest extends IApplication {
    public void start() {
        Display.setCurrent(new TestCanvas());
    }
}

class TestCanvas extends Canvas {
    private Image m_image;

    public TestCanvas() {
        MediaImage mi = MediaManager.getImage("resource:///test.gif");
        try {
            mi.use();
        } catch (Exception e) {
            e.printStackTrace();
        }
        m_image = mi.getImage();
        setBackground(Graphics.getColorOfName(Graphics.WHITE));
    }

    public void paint(Graphics g) {
        g.clearRect(0, 0, getWidth(), getHeight());
        g.drawImage(m_image,
                    (getWidth() - m_image.getWidth()) / 2,
                    (getHeight() - m_image.getHeight()) / 2);
    }
}
