<?php
// $Horde: imp/lib/Maintenance/imp.php,v 1.1.2.4 2002/04/12 16:57:58 jan Exp $

include_once HORDE_BASE . '/lib/Maintenance.php';
include_once $GLOBALS['registry']->getParam('fileroot', 'imp') . '/lib/base.php';

/**
* The Maintenance_IMP class defines the maintenance operations run upon
* login to IMP.
*
* See the enclosed file COPYING for license information (GPL).  If you
* did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
*
* @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
* @version $Revision: 1.1.1.1 $
* @since   IMP 3.0.0
* @package horde.maintenance
*/
class Maintenance_IMP extends Maintenance {

    /**
     * Hash holding maintenance preference names.
     *
     * @var array $maint_tasks
     */
    var $maint_tasks = array(
        'rename_sentmail_monthly' => MAINTENANCE_MONTHLY,
        'delete_sentmail_monthly' => MAINTENANCE_MONTHLY,
        'purge_trash'             => MAINTENANCE_MONTHLY
    );

    /**
     * Page to load after maintenance screen is shown.
     *
     * @var string $postpage
     */
    var $postpage = 'redirect.php';

    /**
     * Constructor
     *
     * @access public
     */
    function Maintenance_IMP()
    {
        IMP::setupSession();
        parent::Maintenance();
    }

    /**
     * Do maintenance operations needed for this login.
     *
     * @access public
     */
    function runMaintenance()
    {
        IMP::setupSession();
        parent::runMaintenance();
    }

}
?>
