<?php
/*
 * $Horde: imp/view.php,v 2.101.2.7 2002/06/05 22:46:52 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));

$session_control = 'cache_ssl_downloads';
require_once IMP_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/MIME.php';
require_once HORDE_BASE . '/lib/SessionCache.php';
require_once HORDE_BASE . '/lib/MIME/Part.php';
require_once HORDE_BASE . '/lib/MIME/Viewer.php';
require_once HORDE_BASE . '/config/mime_drivers.php';
require_once HORDE_BASE . '/config/mime_mapping.php';
require_once IMP_BASE .   '/config/mime_drivers.php';

if (($reason = IMP::authenticate(null, true)) !== true) {
    header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php?url=' . Horde::selfUrl(), $reason), true));
    exit;
}

$actionID = Horde::getFormData('actionID');
$index = Horde::getFormData('index');

if (($actionID != SAVE_MESSAGE) && ($actionID != VIEW_SOURCE)) {
    $mime = SessionCache::getObject(Horde::getFormData('mime'));
    if (empty($mime)) {
        include_once HORDE_BASE . '/lib/MIME/Structure.php';
        $structure = imap_fetchstructure($imp['stream'], $index, FT_UID);
        $attachments = MIME_Structure::parse($structure, $index, $MimeID);
        $mime = $attachments[Horde::getFormData('id')];
    }
}


/* Run through action handlers */
switch ($actionID) {
 case DOWNLOAD_ATTACH:
     if (ini_get('output_handler'))
	 ob_end_clean();
     header('Content-Type: application/x-unknown-' . $mime_types[$mime->type] . '-' . $mime->subtype);

     /* This should force a save file dialog. According to a note
      * in MSDN, the suggested filename should NOT be in quotes.
      *
      * For IE 5.5, we break the header in a special way that makes
      * things work. I don't really want to know. */
     if ($GLOBALS['language'] == 'ja_JP') {
	 if ($GLOBALS['browser']->platform == 'unix')
	     $name = urlencode(mb_convert_encoding(MIME::decode($mime->name), 'EUC-JP'));
	 else
	     $name = mb_convert_encoding(MIME::decode($mime->name), 'SJIS');
     } else
	 $name = MIME::decode($mime->name);
     if ($browser->hasQuirk('break_disposition_header')) {
	 header('Content-Disposition: filename=' . $name);
     } else {
	 header('Content-Disposition: attachment; filename=' . $name);
     }
     break;

 case VIEW_ATTACH:
     $mime_type = $mime->TYPE . '/' . $mime->subtype;

     /* If this is a text/html part, then we need to scan for CIDs
      * embedded in it in order to display images that might be
      * inlined in other parts of the message. */
     if ($mime_type == 'text/html' ) {
         include_once HORDE_BASE . '/lib/MIME/Structure.php';
         MIME_Structure::parse(imap_fetchstructure($imp['stream'], $index, FT_UID), $index, $MimeID);
     }

     $ob = new MIME_Part($mime_type, IMP::getDecodedPart($mime), $mime->charset);
     if (isset($mime->filename)) {
         $ob->setName($mime->filename);
     }
     $viewer = &MIME_Viewer::factory($ob);

     if ($viewer->getType() != 'text/html') {
	 if (ini_get('output_handler'))
	     ob_end_clean();
	 header('Content-Type: ' . $viewer->getType() . '; charset=' . $viewer->getCharset($ob));
     }
     header('Content-Disposition: inline; filename=' . MIME::decode($mime->name));
     print $viewer->render($mime);
     exit;
     break;

 case VIEW_SOURCE:
     $msg = imap_fetchheader($imp['stream'], $index, FT_UID) . "\n" . imap_body($imp['stream'], $index, FT_UID);
     if ($GLOBALS['language'] == 'ja_JP')
	 $msg = mb_convert_encoding($msg, mb_internal_encoding(), 'JIS');
     header('Content-Type: text/plain');
     header('Content-Disposition: inline; filename=Message Source');
     header('Content-Length: ' . strlen($msg));
     echo $msg;
     exit;

 case SAVE_MESSAGE:
     $h = imap_header($imp['stream'], imap_msgno($imp['stream'], $index));

     if (!empty($h->subject)) {
	 if ($GLOBALS['language'] == 'ja_JP')
	     $name = mb_decode_mimeheader($h->subject);
	 else
	     $name = preg_replace('|\W|', '_', MIME::decode($h->subject));
     } else
	 $name = 'message';

     $from = '<>';
     if (isset($h->from[0])) {
         if (isset($h->from[0]->mailbox) && isset($h->from[0]->host)) {
             $from = $h->from[0]->mailbox . '@' . $h->from[0]->host;
         }
     }
     $date  = strftime('%a %b %d %H:%M:%S %Y', $h->udate);
     $body  = 'From ' . $from . ' ' . $date. "\n";
     $body .= imap_fetchheader($imp['stream'], $index, FT_UID);
     $body .= imap_body($imp['stream'], $index, FT_UID);
     $body  = str_replace("\r\n", "\n", $body);

     if (ini_get('output_handler'))
	 ob_end_clean();
     header('Content-Type: application/RFC822');

     /* This should force a save file dialog.  According to a note
      * in MSDN, the suggested filename should NOT be in quotes.
      *
      * For IE 5.5, we break the header in a special way that makes
      * things work. I don't really want to know. */
     if ($GLOBALS['language'] == 'ja_JP') {
	 if ($GLOBALS['browser']->platform == 'unix')
	     $name = urlencode($name);
	 else
	     $name = mb_convert_encoding($name, 'SJIS', 'auto');
     }
     if ($browser->hasQuirk('break_disposition_header')) {
         header("Content-Disposition: filename=$name");
     } else {
         header("Content-Disposition: attachment; filename=$name");
     }
     break;
}

if ($actionID != SAVE_MESSAGE) {
    $body = imap_fetchbody($imp['stream'], $index, Horde::getFormData('id'), FT_UID);

    if ($mime->encoding == ENCBASE64) {
        $body = imap_base64($body);
    } elseif ($mime->encoding == ENCQUOTEDPRINTABLE && ($qprint_msg = imap_qprint($body))) {
        $body = $qprint_msg;
    }
}

header('Content-Length: ' . strlen($body));
echo $body;

?>
