<?php
/*
 * $Horde: turba/addobjectaction.php,v 1.5.2.6 2002/03/19 01:59:24 chuck Exp $
 *
 * Turba: Copyright 2000-2002 Charles J. Hagenbuch <chuck@horde.org>
 *
 * You should have received a copy of the GNU Public
 * License along with this package; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Source.php';
require TURBA_BASE . '/config/attributes.php';

$source = Horde::getFormData('source');
$driver = &Turba_Source::singleton($source, $cfgSources[$source]);
$object = Horde::getFormData('object');
foreach ($object as $key => $value) {
    if (isset($attributes[$key]) && $attributes[$key]['type'] == 'date') {
        if ($value['month'] == '' || $value['day'] == '' || $value['year'] == '') {
            $object[$key] = null;
        } else {
            $object[$key] = mktime(0, 0, 0, $value['month'], $value['day'], $value['year']);
        }
    }
}

$key = $driver->addObject($object);

if (!PEAR::isError($key)) {
    header('Location: ' . Horde::url('displayobject.php?source=' . urlencode($source) . '&key=' . urlencode($key), true));
} else {
    Horde::logMessage($key, __FILE__, __LINE__, LOG_ERR);
    Horde::raiseMessage(_("There was an error adding this object. Contact your system administrator for further help."), HORDE_ERROR);

    $title = _("Add failed");
    $js_onLoad = null;
    include TURBA_TEMPLATES . '/common-header.inc';
    include TURBA_BASE . '/menu.php';
    include TURBA_BASE . '/status.php';
    include TURBA_TEMPLATES . '/common-footer.inc';
}

?>
