<?php
// $Horde: turba/lib/ObjectView.php,v 1.6.2.2 2002/04/12 16:10:07 jan Exp $

/**
 * The Turba_ObjectView:: class provides an interface for visualizing
 * a Turba_AbstractObject.
 *
 * @author   Chuck Hagenbuch <chuck@horde.org>
 * @version  $Revision: 1.1.1.1 $
 * @since Turba 0.0.1
 * @package turba
 */
class Turba_ObjectView {

	/**
     * The object that this Turba_ObjectView displays.
     * @var	Turba_AbstractObject
     */
    var $object;

    /**
     * The template used to display the object.
     * @var string
     */
    var $template;


    /**
     * Constructs a new Turba_ObjectView object.
     *
     * @param $object   The object to display.
     * @param $template What template file to display this object with.
     */
    function Turba_ObjectView(&$object, $template)
    {
        $this->object = &$object;
        $this->template = $template;
    }


    /**
     * Renders the object into an HTML view.
     */
    function display()
    {
        include TURBA_BASE . '/config/attributes.php';

        $fields = $this->object->source->getCriteria();
        include $this->template;
    }

}
?>
