<?php
// Format the address according to RFC822.
// FIXME: should not rely on the imap extension.

// Build the columns to display
$show = array();
$address = '';
foreach ($GLOBALS['columns'] as $column) {
    if ($ob->hasValue($column)) {
        $show[$column] = $ob->getValue($column);
        if ($GLOBALS['attributes'][$column]['type'] == 'email') {
            $mailbox_host = explode('@', $show[$column]);
            if (!isset($mailbox_host[1])) {
                $mailbox_host[1] = '';
            }
            $name = $ob->getValue('name');
            $address = imap_rfc822_write_address($mailbox_host[0], $mailbox_host[1], $name);

            // Get rid of the trailing @ (when no host is included in the email address).
            $address = str_replace('@>', '>', $address);

            $show[$column] = '<a href="' . $GLOBALS['registry']->link('mail/compose', array('to' => addslashes($address))) . '">' . $show[$column] . '</a>';
        }
    } else {
        $show[$column] = '&nbsp;';
    }
}

if ($this->list->isFresh($ob)) {
    $class = 'listitem';
    $hi = $css['.listitem-hi']['background-color'];
    $lo = $css['.listitem']['background-color'];
} else {
    $class = 'oldlistitem';
    $hi = $css['.oldlistitem-hi']['background-color'];
    $lo = $css['.oldlistitem']['background-color'];
}
?><tr class="<?= $class ?>" onmouseover="javascript:style.backgroundColor='<?= $hi ?>';" onmouseout="javascript:style.backgroundColor='<?= $lo ?>';">
    <td>
        <?php if ($ob->hasValue('__key')): ?><?= Horde::link(Horde::applicationUrl('displayobject.php?source=' . urlencode($GLOBALS['source']) . '&key=' . urlencode($ob->getValue('__key'))), sprintf(_("Edit '%s'"), $ob->getValue('name'))); ?><?php endif; ?><?= $ob->hasValue('name') ? $ob->getValue('name') : _("[Edit]") ?><?php if ($ob->hasValue('__key')): ?></a><?php endif; ?>
    </td>
<?php foreach ($show as $field): ?>
    <td>
        <?= $field ?>
    </td>
<?php endforeach; ?>
</tr>
