<?php
// Format the address according to RFC822.
// FIXME: should not rely on the imap extension.

// Build the columns to display
$show = array();
$address = '';
foreach ($GLOBALS['columns'] as $column) {
    if ($ob->hasValue($column)) {
        if ($column == 'name') {
            $ob->setValue('name', Turba::formatName($ob->getValue('name')));
        }
        $show[$column] = htmlspecialchars($ob->getValue($column));
        if ($GLOBALS['attributes'][$column]['type'] == 'email') {
            // Format the address according to RFC822.
            $mailbox_host = explode('@', $show[$column]);
            if (!isset($mailbox_host[1])) {
                $mailbox_host[1] = '';
            }
            $name = $ob->getValue('name');
            $address = imap_rfc822_write_address($mailbox_host[0], $mailbox_host[1], $name);
            // Get rid of the trailing @ (when no host is included in the email address).
            $address = str_replace('@>', '>', $address);
            $mail_link = $GLOBALS['registry']->link('mail/compose', array('to' => addslashes($address)));
            if (PEAR::isError($mail_link)) {
                $mail_link = 'mailto:' . urlencode($address);
            }

            $show[$column] = '<a href="' . $mail_link . '">' . htmlspecialchars($show[$column]) . '</a>';
        }
    } else {
        $show[$column] = '&nbsp;';
    }
}

if ($this->list->isFresh($ob)) {
    $class = 'listitem';
    $hi = $css['.listitem-hi']['background-color'];
    $lo = $css['.listitem']['background-color'];
} else {
    $class = 'oldlistitem';
    $hi = $css['.oldlistitem-hi']['background-color'];
    $lo = $css['.oldlistitem']['background-color'];
}
?><tr class="<?php echo $class ?>" onmouseover="javascript:style.backgroundColor='<?php echo $hi ?>';" onmouseout="javascript:style.backgroundColor='<?php echo $lo ?>';">
  <td>
    <?php if ($ob->hasValue('__key')): ?>
      <?php echo Horde::link(Horde::applicationUrl('displayobject.php?source=' . urlencode($ob->source->name) . '&key=' . urlencode($ob->getValue('__key'))), sprintf(_("Edit '%s'"), $ob->getValue('name'))); ?><?php endif; ?><?php echo $ob->hasValue('name') ? htmlspecialchars($ob->getValue('name')) : _("[Edit]") ?><?php if ($ob->hasValue('__key')): ?></a>
    <?php endif; ?>
  </td>
<?php foreach ($show as $field): ?>
  <td>
    <?php echo $field ?>
  </td>
<?php endforeach; ?>
</tr>
