/******************************************************************************/
/*! @file table_koi8_unicode.cc
    @brief Header file of KOI8/UCS-2 table.
    @author Tachibanamasashi, Apolloron Project.
 ******************************************************************************/

#include "table_koi8_unicode.h"

namespace apolloron {

/* KOI8-R  0x80-0xFF */
const unsigned char koi8_r_unicode[KOI8_UNICODE_TABLE_MAX][2] = {
  {0x25, 0x00}, {0x25, 0x02}, {0x25, 0x0C}, {0x25, 0x10},
  {0x25, 0x14}, {0x25, 0x18}, {0x25, 0x1C}, {0x25, 0x24},
  {0x25, 0x2C}, {0x25, 0x34}, {0x25, 0x3C}, {0x25, 0x80},
  {0x25, 0x84}, {0x25, 0x88}, {0x25, 0x8C}, {0x25, 0x90},
  {0x25, 0x91}, {0x25, 0x92}, {0x25, 0x93}, {0x23, 0x20},
  {0x25, 0xA0}, {0x22, 0x19}, {0x22, 0x1A}, {0x22, 0x48},
  {0x22, 0x64}, {0x22, 0x65}, {0x00, 0xA0}, {0x23, 0x21},
  {0x00, 0xB0}, {0x00, 0xB2}, {0x00, 0xB7}, {0x00, 0xF7},
  {0x25, 0x50}, {0x25, 0x51}, {0x25, 0x52}, {0x04, 0x51},
  {0x25, 0x53}, {0x25, 0x54}, {0x25, 0x55}, {0x25, 0x56},
  {0x25, 0x57}, {0x25, 0x58}, {0x25, 0x59}, {0x25, 0x5A},
  {0x25, 0x5B}, {0x25, 0x5C}, {0x25, 0x5D}, {0x25, 0x5E},
  {0x25, 0x5F}, {0x25, 0x60}, {0x25, 0x61}, {0x04, 0x01},
  {0x25, 0x62}, {0x25, 0x63}, {0x25, 0x64}, {0x25, 0x65},
  {0x25, 0x66}, {0x25, 0x67}, {0x25, 0x68}, {0x25, 0x69},
  {0x25, 0x6A}, {0x25, 0x6B}, {0x25, 0x6C}, {0x00, 0xA9},
  {0x04, 0x4E}, {0x04, 0x30}, {0x04, 0x31}, {0x04, 0x46},
  {0x04, 0x34}, {0x04, 0x35}, {0x04, 0x44}, {0x04, 0x33},
  {0x04, 0x45}, {0x04, 0x38}, {0x04, 0x39}, {0x04, 0x3A},
  {0x04, 0x3B}, {0x04, 0x3C}, {0x04, 0x3D}, {0x04, 0x3E},
  {0x04, 0x3F}, {0x04, 0x4F}, {0x04, 0x40}, {0x04, 0x41},
  {0x04, 0x42}, {0x04, 0x43}, {0x04, 0x36}, {0x04, 0x32},
  {0x04, 0x4C}, {0x04, 0x4B}, {0x04, 0x37}, {0x04, 0x48},
  {0x04, 0x4D}, {0x04, 0x49}, {0x04, 0x47}, {0x04, 0x4A},
  {0x04, 0x2E}, {0x04, 0x10}, {0x04, 0x11}, {0x04, 0x26},
  {0x04, 0x14}, {0x04, 0x15}, {0x04, 0x24}, {0x04, 0x13},
  {0x04, 0x25}, {0x04, 0x18}, {0x04, 0x19}, {0x04, 0x1A},
  {0x04, 0x1B}, {0x04, 0x1C}, {0x04, 0x1D}, {0x04, 0x1E},
  {0x04, 0x1F}, {0x04, 0x2F}, {0x04, 0x20}, {0x04, 0x21},
  {0x04, 0x22}, {0x04, 0x23}, {0x04, 0x16}, {0x04, 0x12},
  {0x04, 0x2C}, {0x04, 0x2B}, {0x04, 0x17}, {0x04, 0x28},
  {0x04, 0x2D}, {0x04, 0x29}, {0x04, 0x27}, {0x04, 0x2A}
};


/* KOI8-U  0x80-0xFF */
const unsigned char koi8_u_unicode[KOI8_UNICODE_TABLE_MAX][2] = {
  {0x25, 0x00}, {0x25, 0x02}, {0x25, 0x0C}, {0x25, 0x10},
  {0x25, 0x14}, {0x25, 0x18}, {0x25, 0x1C}, {0x25, 0x24},
  {0x25, 0x2C}, {0x25, 0x34}, {0x25, 0x3C}, {0x25, 0x80},
  {0x25, 0x84}, {0x25, 0x88}, {0x25, 0x8C}, {0x25, 0x90},
  {0x25, 0x91}, {0x25, 0x92}, {0x25, 0x93}, {0x23, 0x20},
  {0x25, 0xA0}, {0x22, 0x19}, {0x22, 0x1A}, {0x22, 0x48},
  {0x22, 0x64}, {0x22, 0x65}, {0x00, 0xA0}, {0x23, 0x21},
  {0x00, 0xB0}, {0x00, 0xB2}, {0x00, 0xB7}, {0x00, 0xF7},
  {0x25, 0x50}, {0x25, 0x51}, {0x25, 0x52}, {0x04, 0x51},
  {0x04, 0x54}, {0x25, 0x54}, {0x04, 0x56}, {0x04, 0x57},
  {0x25, 0x57}, {0x25, 0x58}, {0x25, 0x59}, {0x25, 0x5A},
  {0x25, 0x5B}, {0x04, 0x91}, {0x25, 0x5D}, {0x25, 0x5E},
  {0x25, 0x5F}, {0x25, 0x60}, {0x25, 0x61}, {0x04, 0x01},
  {0x04, 0x04}, {0x25, 0x63}, {0x04, 0x06}, {0x04, 0x07},
  {0x25, 0x66}, {0x25, 0x67}, {0x25, 0x68}, {0x25, 0x69},
  {0x25, 0x6A}, {0x04, 0x90}, {0x25, 0x6C}, {0x00, 0xA9},
  {0x04, 0x4E}, {0x04, 0x30}, {0x04, 0x31}, {0x04, 0x46},
  {0x04, 0x34}, {0x04, 0x35}, {0x04, 0x44}, {0x04, 0x33},
  {0x04, 0x45}, {0x04, 0x38}, {0x04, 0x39}, {0x04, 0x3A},
  {0x04, 0x3B}, {0x04, 0x3C}, {0x04, 0x3D}, {0x04, 0x3E},
  {0x04, 0x3F}, {0x04, 0x4F}, {0x04, 0x40}, {0x04, 0x41},
  {0x04, 0x42}, {0x04, 0x43}, {0x04, 0x36}, {0x04, 0x32},
  {0x04, 0x4C}, {0x04, 0x4B}, {0x04, 0x37}, {0x04, 0x48},
  {0x04, 0x4D}, {0x04, 0x49}, {0x04, 0x47}, {0x04, 0x4A},
  {0x04, 0x2E}, {0x04, 0x10}, {0x04, 0x11}, {0x04, 0x26},
  {0x04, 0x14}, {0x04, 0x15}, {0x04, 0x24}, {0x04, 0x13},
  {0x04, 0x25}, {0x04, 0x18}, {0x04, 0x19}, {0x04, 0x1A},
  {0x04, 0x1B}, {0x04, 0x1C}, {0x04, 0x1D}, {0x04, 0x1E},
  {0x04, 0x1F}, {0x04, 0x2F}, {0x04, 0x20}, {0x04, 0x21},
  {0x04, 0x22}, {0x04, 0x23}, {0x04, 0x16}, {0x04, 0x12},
  {0x04, 0x2C}, {0x04, 0x2B}, {0x04, 0x17}, {0x04, 0x28},
  {0x04, 0x2D}, {0x04, 0x29}, {0x04, 0x27}, {0x04, 0x2A}
};


/* CP1251  0x80-0xFF */
const unsigned char cp1251_unicode[KOI8_UNICODE_TABLE_MAX][2] = {
  {0x04, 0x02}, {0x04, 0x03}, {0x20, 0x1A}, {0x04, 0x53},
  {0x20, 0x1E}, {0x20, 0x26}, {0x20, 0x20}, {0x20, 0x21},
  {0x20, 0xAC}, {0x20, 0x30}, {0x04, 0x09}, {0x20, 0x39},
  {0x04, 0x0A}, {0x04, 0x0C}, {0x04, 0x0B}, {0x04, 0x0F},
  {0x04, 0x52}, {0x20, 0x18}, {0x20, 0x19}, {0x20, 0x1C},
  {0x20, 0x1D}, {0x20, 0x22}, {0x20, 0x13}, {0x20, 0x14},
  {0x00, 0x3F}, {0x21, 0x22}, {0x04, 0x59}, {0x20, 0x3A},
  {0x04, 0x5A}, {0x04, 0x5C}, {0x04, 0x5B}, {0x04, 0x5F},
  {0x00, 0xA0}, {0x04, 0x0E}, {0x04, 0x5E}, {0x04, 0x08},
  {0x00, 0xA4}, {0x04, 0x90}, {0x00, 0xA6}, {0x00, 0xA7},
  {0x04, 0x01}, {0x00, 0xA9}, {0x04, 0x04}, {0x00, 0xAB},
  {0x00, 0xAC}, {0x00, 0xAD}, {0x00, 0xAE}, {0x04, 0x07},
  {0x00, 0xB0}, {0x00, 0xB1}, {0x04, 0x06}, {0x04, 0x56},
  {0x04, 0x91}, {0x00, 0xB5}, {0x00, 0xB6}, {0x00, 0xB7},
  {0x04, 0x51}, {0x21, 0x16}, {0x04, 0x54}, {0x00, 0xBB},
  {0x04, 0x58}, {0x04, 0x05}, {0x04, 0x55}, {0x04, 0x57},
  {0x04, 0x10}, {0x04, 0x11}, {0x04, 0x12}, {0x04, 0x13},
  {0x04, 0x14}, {0x04, 0x15}, {0x04, 0x16}, {0x04, 0x17},
  {0x04, 0x18}, {0x04, 0x19}, {0x04, 0x1A}, {0x04, 0x1B},
  {0x04, 0x1C}, {0x04, 0x1D}, {0x04, 0x1E}, {0x04, 0x1F},
  {0x04, 0x20}, {0x04, 0x21}, {0x04, 0x22}, {0x04, 0x23},
  {0x04, 0x24}, {0x04, 0x25}, {0x04, 0x26}, {0x04, 0x27},
  {0x04, 0x28}, {0x04, 0x29}, {0x04, 0x2A}, {0x04, 0x2B},
  {0x04, 0x2C}, {0x04, 0x2D}, {0x04, 0x2E}, {0x04, 0x2F},
  {0x04, 0x30}, {0x04, 0x31}, {0x04, 0x32}, {0x04, 0x33},
  {0x04, 0x34}, {0x04, 0x35}, {0x04, 0x36}, {0x04, 0x37},
  {0x04, 0x38}, {0x04, 0x39}, {0x04, 0x3A}, {0x04, 0x3B},
  {0x04, 0x3C}, {0x04, 0x3D}, {0x04, 0x3E}, {0x04, 0x3F},
  {0x04, 0x40}, {0x04, 0x41}, {0x04, 0x42}, {0x04, 0x43},
  {0x04, 0x44}, {0x04, 0x45}, {0x04, 0x46}, {0x04, 0x47},
  {0x04, 0x48}, {0x04, 0x49}, {0x04, 0x4A}, {0x04, 0x4B},
  {0x04, 0x4C}, {0x04, 0x4D}, {0x04, 0x4E}, {0x04, 0x4F}
};


} // namespace apolloron
