/******************************************************************************/
/*! @file apolloron_html_client.h
    @brief Header file of libapolloron_html_client.
    @author Tachibanamasashi, Apolloron Project.
    @date 2009-07-17
 ******************************************************************************/

#ifndef _APOLLORON_HTML_CLIENT_H_
#define _APOLLORON_HTML_CLIENT_H_

#include "apolloron.h"

namespace apolloron_html_client {

/*! @brief Version of libapolloron_html_client.
 */
#define LIBAPOLLORON_HTML_CLIENT_VERSION "0.02.0"


/*----------------------------------------------------------------------------*/
/* HTMLClient class                                                           */
/*----------------------------------------------------------------------------*/
/*! @brief Class of HTML client
 */ 
class HTMLClient {
protected:
  apolloron::String content;
  apolloron::String origCharset;
public:
  HTMLClient();
  virtual ~HTMLClient();

  // Deletion of String instance
  virtual bool clear();

  // get content specified by URL
  virtual apolloron::String& getURL(const apolloron::String &url, long timeout=5);

  // get content original charset 
  virtual apolloron::String& getOrigCharset();
};

} // namespace apolloron_html_client

#endif
