<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * ログイン/ログアウトのコントローラークラス
 *
 * @author 
 * @copyright COPYRIGHT &copy 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 * @version 
 * @package 
 * @see AbstractController
 */
class Inqman_AccountController extends AbstractController
{
    /*** Public Methods ***/    

	/**
	 * preDispatch
	 * 
	 * 認証チェックを行わないために空オーバーライド
	 */
	public function preDispatch()
	{
	    //認証チェックは行わないため処理なしでオーバーライド
	}
	
	/**
	 * インデックス（ログイン）画面を表示する
	 * 
	 * @access public
	 * 
	 */
	public function indexAction()
	{
        $this->_setupPageTitle('login', 'account');
	    
	    //ログイン後転送用パラメータがある場合は、VIEWに渡す
	    $forwardParams = $this->getRequest()->getParam(REQUEST_KEY_FORWARD);
	    $this->view->assign(VIEW_KEY_FORRWARD_PARAMS, $forwardParams);
	}
	
	/**
	 * ログイン認証処理を実行する
	 * 
	 * @access public
	 * 
	 */
	public function loginAction()
	{
	    //フォーム入力値を検証
	    $form = new AccountForm();
	    if($form->isValid($_POST)) {
    	    
	        //入力値に問題ない場合は、ユーザIDとパスワードとして取得
	        //このときパスワードはSHA-1ハッシュとする
    	    $user_id   = $form->getValue(AccountForm::USER_ID);
    	    $password = sha1($form->getValue(AccountForm::PASSWD));
    	    
    	    //ログイン認証を行う
    	    $acl_model = new Inqman_AclModel();
    	    if ($acl_model->authenticate($user_id, $password)) {
    	        //認証成功時は転送用パラメータからURLを生成してリダイレクトを行う
    	        $redirect_path = $this->_getRedirectPath($this->getRequest());
    	        if (empty($redirect_path)) {
    	            //転送用パラメータが無い場合はトップ画面に遷移
    	            $redirect_path = "/inquiry/";
    	        }
                $this->_redirect($redirect_path);
    	    } else {
    	        //認証失敗時はエラーメッセージをVIEWに設定して、ログイン画面を再表示
    	        $error_messages = array(array($this->view->translate('loginFailure')));
    	        $this->view->assign(VIEW_KEY_FORM_INPUT, array(AccountForm::USER_ID => $form->getValue(AccountForm::USER_ID)));
    	        $this->view->assign(VIEW_KEY_ERROR_MESSAGES, $error_messages);
    	        $this->_forward('index', 'account');
    	    }
	    } else {//入力値検証に問題があった場合
	        //エラーメッセージをVIEWに設定して、ログインフォームを再表示
	        $this->view->assign(VIEW_KEY_ERROR_MESSAGES, $form->getMessages());
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getUnfilteredValues());
	        $this->_forward('index', 'account');
	    }
	}
	
	/**
	 * ログアウト処理を実行する
	 * 
	 */
	public function logoutAction()
	{
        //認証情報を消去してログイン画面にリダイレクト
	    $auth = Zend_Auth::getInstance();
	    $storage = $auth->getStorage();
	    $storage->clear();
	    $this->_redirect('/inquiry/');
	}
    
	/*** Local Methods ***/
	
	/**
	 * ログイン後にリダイレクトするURLを取得する
	 * 
	 * @access protected
	 * @param Zend_HTTP_Request $request HTTPリクエスト情報（HTTP_Requestオブジェクト）
	 * @return string リダイレクト先のURLを返す
	 * 
	 */
    protected function _getRedirectPath($request)
    {       
        $redirect_path = "";
        
        //パラメータを取得
        $forward_params = $request->getParam(REQUEST_KEY_FORWARD);
        
        if (!empty($forward_params)) {
            $module = $forward_params[$request->getModuleKey()];
            if(null !== $module) $redirect_path .= "/{$module}";
            
            $controller = $forward_params[$request->getControllerKey()];
            if(null !== $controller) $redirect_path .= "/{$controller}";
            
            $action     = $forward_params[$request->getActionKey()];
            if(null !== $action) $redirect_path .= "/{$action}";
            
            foreach ($forward_params as $key => $value) {
                if ($key != $request->getModuleKey() && $key != $request->getControllerKey() && $key != $request->getActionKey()) {
                    $redirect_path .= "/{$key}/{$value}";
                }
            }
        }
        return $redirect_path;
    }
    
}
