<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * イベント設定画面のコントローラークラス
 *
 * @author 
 * @copyright COPYRIGHT &copy 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 * @version 
 * @package 
 * @see AbstractController
 */
class Inqman_EventController extends AbstractController
{
   /**
     * @see AbstractController::createinputAction()
     *
     */
    public function inputAction()
    {
        //ページタイトルの設定
        $this->_setupPageTitle('setup', 'event');
        
        //リクエストパラメータからサービスIDを取得
        $service_id = $this->getRequest()->getParam('service_id');
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_EVENT, ACL_PRIVILEGE_KEY_SETUP, $service_id);
        
        //サービス情報を取得
        $service_model = new Inqman_ServiceModel();
        $service = $service_model->getOneService($service_id);
        $this->view->assign('service', $service);
        
        //イベント情報を取得
        $event_model = new Inqman_EventModel();
        $events = $event_model->getAllEventActions();
        $this->view->assign('events', $events);
        
        //サービス利用可能グループ情報を取得
        $acl_model = new Inqman_AclModel();
        $authority_options = $acl_model->getServiceAuthorityOptions($service_id);
        $this->view->assign('authority_options', $authority_options);
        
        //メールテンプレート情報を取得
        $mailtemplate_model = new Inqman_MailtemplateModel();
        $common_temps = $mailtemplate_model->getCommonMailtemplateOptions();
        $enable_temps = $mailtemplate_model->getServiceEnableMailtemplateOptions($service_id);
        $mailtemplates = array(
                ''        => '----',
                'common'  => $common_temps,
                'enable'  => $enable_temps,
        );
        $this->view->assign('mailtemplate_options', $mailtemplates);
        
        //現在の設定を取得
        $rows = (array) $event_model->getServiceEventsPerEventAction($service_id);
        $form_input = array();
        
        foreach ($rows as $row) {
            $authority_ids = array();
            
            foreach ((array) $row as $service_event) {
                $id              = $service_event['event_action_id'];
                $enable          = $service_event['enable'];
                $mailtemplate_id = $service_event['mailtemplate_id'];
                $authority_ids[] = $service_event['authority_id'];
            }
            
            $form_input[$id] = array(
                    'id'              => $id,
                    'enable'          => $enable,
                    'authority_id'    => $authority_ids, 
                    'mailtemplate_id' => $mailtemplate_id,
            );
        }
        
        $this->view->assign(VIEW_KEY_FORM_INPUT, $form_input);
    }
        
    /**
     * イベント設定実行
     * 
     */
    public function commitAction()
    {
        $events     = $this->getRequest()->getParam('event');
        $service_id = $this->getRequest()->getParam('service_id');
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_EVENT, ACL_PRIVILEGE_KEY_SETUP, $service_id);
        
        $values = array();
        foreach($events as $event) {
            $enable          = $event['enable'];
            $authority_ids   = (array) $event['authority_id'];
            $template_id     = $event['mailtemplate_id'];
            $event_action_id = $event['id'];
            
            if (!empty($enable) && !empty($authority_ids) && !empty($template_id) && !empty($event_action_id)) {
                foreach ($authority_ids as $authority_id) {
                    $value = array(
                            'service_id'      => $service_id,
                            'event_action_id' => $event_action_id,
                            'authority_id'    => $authority_id,
                            'mailtemplate_id' => $template_id,
                    );
                    $values[] = $value;
                }
            }
        }
        $event_model = new Inqman_EventModel();
        $event_model->saveServiceEvent($service_id, $values);
        
        $this->_redirect("/event/input/service_id/{$service_id}/");
    }

}
