<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * IndexController - The default controller class
 * 
 * @author
 * @version 
 */
class Inqman_IndexController extends AbstractController   
{
    /**
     * マイページを表示する
     * 
     * @access public
     */
    public function indexAction()
    {
        //ロジックインスタンスの生成
        $service_model = new Inqman_ServiceModel();
        $acl_model = new Inqman_AclModel();
        
        //ページタイトルの設定
        $this->_setupPageTitle('mypage', 'index');
        
        
        $authorities = array_keys($this->_getUserInfo()->roles);
        
        $is_service_admin = false;
        if ($acl_model->checkAcl(ACL_RESOURCE_KEY_SERVICE, ACL_PRIVILEGE_KEY_READ, 1, $authorities)) {
            $is_service_admin = true;
        }
        
        $is_user_admin = false;
        if ($acl_model->checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_READ, 1, $authorities)) {
            $is_user_admin = true;
        }
        
        //ログインユーザが利用可能なサービス情報を取得
        $enable_services = (array) $service_model->getEnableServices($this->_getUserInfo()->id);
        
        $service_options = array();
        foreach ($enable_services as &$service) {
            
            $is_event_admin = false;
            if ($acl_model->checkAcl(ACL_RESOURCE_KEY_EVENT, ACL_PRIVILEGE_KEY_SETUP, $service['id'], $authorities)) {
                $is_event_admin = true;
            }
            $service['is_event_admin'] = $is_event_admin;
            
            $can_inquiry_accept = false;
            if ($acl_model->checkAcl(ACL_RESOURCE_KEY_INQUIRY, ACL_PRIVILEGE_KEY_ACCEPT, $service['id'], $authorities)) {
                $can_inquiry_accept = true;
            }
            $service['can_inquiry_accept'] = $can_inquiry_accept;
            
            $can_inquiry_approve = false;
            if ($acl_model->checkAcl(ACL_RESOURCE_KEY_INQUIRY, ACL_PRIVILEGE_KEY_APPROVE, $service['id'], $authorities)) {
                $can_inquiry_approve = true;
            }
            $service['can_inquiry_approve'] = $can_inquiry_approve;
        }
        
        //表示情報をVIEWに渡す
        $this->view->assign('is_user_admin', $is_user_admin);
        $this->view->assign('is_service_admin', $is_service_admin);
        $this->view->assign('enable_services', $enable_services);
    }

}
