<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

class Inqman_ReplyForm extends AbstractForm
{

    const ID             = 'id';
    const SUBJECT        = 'subject';
    const CONTENT        = 'content';
    const RESPONSE_DAY   = 'response_datetime';
    const PRIORITY       = 'priority';
    const SERVICE_ID     = 'service_id';
    const METHOD         = 'method';
    const RESPONDENT_ID  = 'respondent_id';
    const INQUIRY_ID     = 'inquiry_id';
    const PARENT_ID      = 'parent_id';
    const TYPE           = 'type';
    
	/**
	 * @see AbstractForm::_prepareFilters()
	 *
	 */
	protected function _prepareFilters()
	{
	}
	
	/**
	 * @see AbstractForm::_prepareValidators()
	 *
	 */
	protected function _prepareValidators()
	{
	    $validators = array();
	    $validate_config = $this->_config->validate->reply;
        
	    //件名のバリデーション設定
        $fieldValidator = new Zend_Validate();        
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_StringLength(0, $validate_config->subject->get('max_length', 200)));
        $validators[self::SUBJECT] = $fieldValidator;
        
        //内容のバリデーション設定
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_StringLength(0, $validate_config->content->get('max_length', 2000)));
        $validators[self::CONTENT] = $fieldValidator;
        
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_Int())
        ;
        $validators[self::METHOD] = $fieldValidator;

        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_Int())
        ;
        $validators[self::PRIORITY] = $fieldValidator;
        
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_Int());
        $validators[self::TYPE] = $fieldValidator;
        
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_Int())
        ;
        $validators[self::RESPONDENT_ID] = $fieldValidator;

        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_Int());
        $validators[self::INQUIRY_ID] = $fieldValidator;

        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_Int());
        $validators[self::PARENT_ID] = $fieldValidator;

        return $validators;
	}

}

?>
