<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * メールテンプレート操作のロジッククラス
 *
 * @author 
 * @copyright COPYRIGHT &copy 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 * @version 
 * @package 
 * @see AbstractModel
 */
class Inqman_MailtemplateModel extends Inqman_AbstractDao
{
    
    const ID         = 'id';
    const NAME       = 'name';
    const MAIL_FROM  = 'mail_from';
    const SUBJECT    = 'subject';
    const CONTENT    = 'content';
    const SERVICE_ID = 'service_id';
    
    protected $_name = 't_mailtemplate';
    
    /**
     * 指定されたメールテンプレート情報を取得する
     * 
     * @param integer $mailtemplate_id
     * @return array メールテンプレート情報を連想配列で返す
     */
    public function getOneMailtemplate($mailtemplate_id)
    {
        $db = $this->getAdapter();
        
        $select = $db->select()
                     ->from(array('m'=>'t_mailtemplate'))
                     ->where('m.id=?', $mailtemplate_id)
        ;
        $this->_logger->info('Inqman_MailtemplateModel->getOneMailtemplate : ' . $select->__toString());
        
        return $db->fetchRow($select);
    }
    
   /**
     * 指定したサービスが利用できるメールテンプレートを取得する
     * 
     * @param integer $serviceId サービスID
     * @return array $result メールテンプレート情報を連想配列で返す
     */
    public function getServiceEnableMailtemplates($service_id)
    {        
        $db = $this->getAdapter();
        $select = $db->select()
                ->from('t_mailtemplate')
                ->where('service_id=?', $service_id)
                ->order('ID ASC')
        ;
        $this->_logger->info('Inqman_MailtemplateModel->getServiceEnableMailtemplates : ' . $select->__toString());
        $result = $db->fetchAll($select);
        
        return $result;
    }
    
    /**
     * 共通メールテンプレート情報を取得する
     * 
     * @return array $result メールテンプレート情報を連想配列で返す
     */
    public function getCommonMailtemplate()
    {
        $db = $this->getAdapter();
        $select = $db->select()
                ->from('t_mailtemplate')
                ->where('service_id=?', 1)
                ->order('ID ASC')
        ;
        $result = $db->fetchAssoc($select);
        
        return $result;
    }
    
    /**
     * 指定したサービスが利用できるメールテンプレートIDを取得する
     * 
     * @param integer $serviceId サービスID
     * @return array $result メールテンプレートIDを（key=id, value=name）の連想配列で返す
     * 
     */
    public function getServiceEnableMailtemplateOptions($serviceId)
    {
        $db = $this->getAdapter();
        $select = $db->select()
                ->from('t_mailtemplate', array('id', 'name'))
                ->where('service_id=?', $serviceId)
                ->order('ID ASC')
        ;
        $result = $db->fetchPairs($select);
        
        return $result;
    }
    
    /**
     * 共通メールテンプレートIDを取得する
     * 
     * @return array $result メールテンプレートIDを（key=id, value=name）の連想配列で返す
     */
    public function getCommonMailtemplateOptions()
    {
        $db = $this->getAdapter();
        $select = $db->select()
                ->from('t_mailtemplate', array('id', 'name'))
                ->where('service_id=?', 1)
                ->order('ID ASC')
        ;
        $result = $db->fetchPairs($select);
        
        return $result;
    }
    
    /**
     * メールテンプレート置換用のシステム変数情報を取得する
     * 
     */
    public function getSysvars()
    {
        $db = $this->getAdapter();
        $select = $db->select()
                     ->from('m_sysvar')
                     ->order('id asc')
        ;
        $this->_logger->info('Inqman_MailtemplateModel->getSysvars : ' . $select->__toString());
        return $db->fetchAll($select);
    }
    
    /**
     * テキスト内のシステム変数を置換する
     * 
     */
    public function replaceSysvar($text, $criteria)
    {
        $db = $this->getAdapter();
        
        preg_match_all('/{\$[a-zA-z\-]+}/i', $text, $matches);
        
        $service_model = new Inqman_ServiceModel();
        $inquiry_model = new Inqman_InquiryModel();
        $reply_model   = new Inqman_ReplyModel();
        
        if (!empty($criteria['service_id'])) {
            $service = $service_model->getOneService($criteria['service_id']);
        }
        if (!empty($criteria['inquiry_id'])) {
            $inquiry = $inquiry_model->getOneInquiry($criteria['inquiry_id']);
        }
        if (!empty($criteria['reply_id'])) {
            $reply = $reply_model->getOneReply($criteria['reply_id']);
        }
        
        foreach ($matches[0] as $sysvar) {
            
            $select = $db->select()
                         ->from('m_sysvar')
                         ->where('var_name=?', $sysvar);
            $row = $db->fetchRow($select);
            
            $table  = $row['table_name'];
            $column = $row['column_name'];
            
            preg_match('/[a-zA-z\-]+/i',  $sysvar, $word);
            $pattern = '/{\$'.$word[0].'}/i';
            
            switch ($table) {
            case 'service' :
                $replace_str = $service[$column];
                $text = preg_replace($pattern, $replace_str, $text);
                break;
            case 'inquiry' :
                $replace_str = $inquiry[$column];
                $text = preg_replace($pattern, $replace_str, $text);
                break;
            case 'reply' :
                $replace_str = $reply[$column];
                $text = preg_replace($pattern, $replace_str, $text);
                break;
            case 'system':
                break;
            default:
                break;
            }
        }
        
        return $text;
    }
    
    /**
     * メールテンプレート編集用のシステム変数情報を連想配列で取得する
     * 
     */
    public function getSysvarOptions()
    {
        $db = $this->getAdapter();
        $select = $db->select()
                     ->from('m_sysvar', array('var_name', 'name'))
                     ->order('id asc')
        ;
        $this->_logger->info('Inqman_MailtemplateModel->getSysvarOptions : ' . $select->__toString());
        return $db->fetchPairs($select);
    }

    /**
     * メールテンプレート設定を登録する
     * 
     * 
     */
    public function createMailtemplate($values)
    {
        $db = $this->getAdapter();
        
        $db->insert('t_mailtemplate', $values);
    }
    
    /**
     * メールテンプレート設定を更新する
     * 
     */
    public function updateMailtemplate($mailtemplate_id, $values)
    {
        $db = $this->getAdapter();
        $where = $db->quoteInto('id=?', $mailtemplate_id);
        $db->update('t_mailtemplate', $values, $where);
    }

}
