/*
ClockPick, by Josh Nathanson
Version 1.2.4
Timepicker plugin for jQuery
See copyright at end of file
Complete documentation at http://www.oakcitygraphics.com/jquery/clockpick/trunk/ClockPick.cfm

name	 clockpick
type	 jQuery
param	 options                  hash                    object containing config options
param	 options[starthour]       int                     starting hour (use military int)
param	 options[endhour]         int                     ending hour (use military int)
param	 options[showminutes]     bool                    show minutes
param 	 options[minutedivisions] int                     number of divisions, i.e. 4 = :00, :15, :30, :45
param 	 options[military]        bool                    use 24hr time if true
param	 options[event]           string                  mouse event to trigger plugin
param	 options[layout]          string                  set div layout to vertical or horizontal
                                  ('vertical','horizontal')
param	 options[valuefield]      string                  field to insert time value, if not same as click field
                                  (name of input field)
param	 options[useBgiframe]	  bool					  set true if using bgIframe plugin
param	 options[hoursopacity]	  float					  set opacity of hours container
param 	 options[minutesopacity]  float					  set opacity of minutes container
param	 callback                 function                callback function - gets passed back the time value as a 
														  string
*/
jQuery.fn.clockpick=function(j,k){var o={starthour:8,endhour:18,showminutes:true,minutedivisions:4,military:false,event:'click',layout:'vertical',valuefield:null,useBgiframe:false,hoursopacity:1,minutesopacity:1};if(j){jQuery.extend(o,j)};var k=k||function(){},v=(o.layout=='vertical');errorcheck();jQuery(this)[o.event](function(e){var g=this,$self=jQuery(this),$body=jQuery("body");if(!o.valuefield){$self.unbind("keydown").bind("keydown",keyhandler)}else{jQuery("[name="+o.valuefield+"]").unbind("keydown").bind("keydown",keyhandler)[0].focus()}jQuery("#CP_hourcont,#CP_minutecont").remove();$hourcont=jQuery("<div id='CP_hourcont' class='CP' />").appendTo($body);!o.useBgiframe?$hourcont.css("opacity",o.hoursopacity):null;binder($hourcont);$hourcol1=jQuery("<div class='CP_hourcol' id='hourcol1' />").appendTo($body);$hourcol2=jQuery("<div class='CP_hourcol' id='hourcol2' />").appendTo($body);if(o.showminutes){$mc=jQuery("<div id='CP_minutecont' class='CP' />").appendTo($body);!o.useBgiframe?$mc.css("opacity",o.minutesopacity):null;binder($mc)}if(!v){$hourcont.css("width","auto");$mc.css("width","auto")}else{$hourcol1.addClass('floatleft');$hourcol2.addClass('floatleft')}renderhours();putcontainer();function renderhours(){var c=1;for(h=o.starthour;h<=o.endhour;h++){if(h==12){c=1}displayhours=((!o.military&&h>12)?h-12:h)+set_tt(h);if(!o.military&&h==0){displayhours='12'+set_tt(h)}$hd=jQuery("<div class='CP_hour' id='hr_"+h+"_"+c+"'>"+displayhours+"</div>");if(o.military){$hd.width(20)}binder($hd);if(!v){$hd.css("float","left")}(h<12)?$hourcol1.append($hd):$hourcol2.append($hd);c++}$hourcont.append($hourcol1);!v?$hourcont.append("<div style='clear:left' />"):'';$hourcont.append($hourcol2)}function renderminutes(h){realhours=h;displayhours=(!o.military&&h>12)?h-12:h;if(!o.military&&h==0){displayhours='12'}$mc.empty();var n=60/o.minutedivisions,tt=set_tt(realhours),counter=1;for(m=0;m<60;m=m+n){$md=jQuery("<div class='CP_minute' id='"+realhours+"_"+m+"'>"+displayhours+":"+((m<10)?"0":"")+m+tt+"</div>");if(!v){$md.css("float","left");if(o.minutedivisions>6&&counter==o.minutedivisions/2+1){$mc.append("<div style='clear:left' />")}}$mc.append($md);binder($md);counter++}}function set_tt(a){if(!o.military){return(a>=12)?' PM':' AM'}else{return''}}function putcontainer(){if(!jQuery.browser.safari&&e.type!='focus'){$hourcont.css("left",e.pageX-5).css("top",e.pageY-(Math.floor($hourcont.height()/2)));rectify($hourcont)}else $self.after($hourcont);$hourcont.show();if(o.useBgiframe)bgi($hourcont)}function rectify(a){var b=document.documentElement.clientHeight?document.documentElement.clientHeight:document.body.clientHeight;var c=document.documentElement.clientWidth?document.documentElement.clientWidth:document.body.clientWidth;if(!jQuery.browser.safari){var t=parseInt(a.css("top"));var l=parseInt(a.css("left"))}else{var t=a[0].offsetTop;var l=a[0].offsetLeft}var d=document.documentElement.scrollTop?document.documentElement.scrollTop:document.body.scrollTop;if(t<=d&&!a.is("#CP_minutecont")){a.css("top",d+10+'px')}else if(t+a.height()-d>b){a.css("top",d+b-a.height()-10+'px')}if(l<=0){a.css("left",'10px')}}function bgi(a){if(typeof jQuery.fn.bgIframe=='function')a.bgIframe();else alert('bgIframe plugin not loaded.')}function binder(a){if(a.attr("id")=='CP_hourcont'){a.mouseout(function(e){hourcont_out(e)})}else if(a.attr("id")=='CP_minutecont'){a.mouseout(function(e){minutecont_out(e)})}else if(a.attr("class")=='CP_hour'){a.mouseover(function(e){hourdiv_over(a,e)});a.mouseout(function(){hourdiv_out(a)});a.click(function(){hourdiv_click(a)})}else if(a.attr("class")=='CP_minute'){a.mouseover(function(){minutediv_over(a)});a.mouseout(function(){minutediv_out(a)});a.click(function(){minutediv_click(a)})}};function hourcont_out(e){try{t=(e.toElement)?e.toElement:e.relatedTarget;if(!(jQuery(t).is("div[@class^=CP], iframe"))){if(!jQuery.browser.safari){cleardivs()}}}catch(e){cleardivs()}}function minutecont_out(e){try{t=(e.toElement)?e.toElement:e.relatedTarget;if(!(jQuery(t).is("div[@class^=CP], iframe"))){if(!jQuery.browser.safari){cleardivs()}}}catch(e){cleardivs()}}function hourdiv_over(a,e){var h=a.attr("id").split('_')[1],i=a.attr("id").split('_')[2],l,t;a.addClass("CP_over");if(o.showminutes){$mc.hide();renderminutes(h);if(v){t=e.type=='mouseover'?e.pageY-15:$hourcont.offset().top+2+(a.height()*i);if(h<12){if(!jQuery.browser.safari){l=$hourcont.offset().left-$mc.width()}else{l=$hourcont[0].offsetLeft-$mc.width()}}else{if(!jQuery.browser.safari){l=$hourcont.offset().left+$hourcont.width()}else{l=$hourcont[0].offsetLeft+$hourcont.width()}}}else{l=(e.type=='mouseover')?e.pageX-10:$hourcont.offset().left+(a.width()-5)*i;if(h<12){if(!jQuery.browser.safari){t=$hourcont.offset().top-$mc.height()}else{t=$hourcont[0].offsetTop-$mc.height()}}else{if(!jQuery.browser.safari){t=$hourcont.offset().top+$hourcont.height()}else{t=$hourcont[0].offsetTop+$hourcont.height()}}}$mc.css("left",l+'px').css("top",t+'px');rectify($mc);$mc.show();if(o.useBgiframe)bgi($mc)}return false}function hourdiv_out(a){a.removeClass("CP_over");return false}function hourdiv_click(a){h=a.attr("id").split('_')[1];tt=set_tt(h);str=a.text();if(str.indexOf(' ')!=-1){cleanstr=str.substring(0,str.indexOf(' '))}else{cleanstr=str}a.text(cleanstr+':00'+tt);setval(a);cleardivs()}function minutediv_over(a){a.addClass("CP_over");return false}function minutediv_out(a){a.removeClass("CP_over");return false}function minutediv_click(a){setval(a);cleardivs()}function setval(a){if(!o.valuefield){g.value=a.text()}else{jQuery("input[@name="+o.valuefield+"]").val(a.text())}k.apply($self,[a.text()]);$self.unbind("keydown",keyhandler)}function cleardivs(){if(o.showminutes){$mc.remove()}$hourcont.remove();$self.unbind("keydown",keyhandler)}function keyhandler(e){var d=$("div.CP_over").size()?$("div.CP_over"):$("div.CP_hour:first"),divtype=d.is(".CP_hour")?'hour':'minute',hi=(divtype=='hour')?d[0].id.split('_')[2]:0,h=(divtype=='minute')?d[0].id.split('_')[0]:d[0].id.split('_')[1];if(divtype=='minute'){var f=h<12?'m1':'m2'}else{var f=h<12?'h1':'h2'}function divprev(a){if(a.prev().size()){eval(divtype+'div_out($obj)');eval(divtype+'div_over($obj.prev(), e)')}else{return false}}function divnext(a){if(a.next().size()){eval(divtype+'div_out($obj)');eval(divtype+'div_over($obj.next(), e)')}else{return false}}function hourtohour(a){var b=h>=12?'#hourcol1':'#hourcol2';$newobj=jQuery(".CP_hour[@id$=_"+hi+"]",b);if($newobj.size()){hourdiv_out(a);hourdiv_over($newobj,e)}else{return false}}function hourtominute(a){hourdiv_out(a);minutediv_over($(".CP_minute:first"))}function minutetohour(a){minutediv_out(a);var b=h>=12?'#hourcol2':'#hourcol1';var c=jQuery(".CP_hour[@id^=hr_"+h+"]",b);hourdiv_over(c,e)}switch(e.keyCode){case 37:if(v){switch(f){case'm1':return false;break;case'm2':minutetohour(d);break;case'h1':hourtominute(d);break;case'h2':hourtohour(d);break}}else{divprev(d)}break;case 38:if(v){divprev(d)}else{switch(f){case'm1':return false;break;case'm2':minutetohour(d);break;case'h1':hourtominute(d);break;case'h2':hourtohour(d);break}}break;case 39:if(v){switch(f){case'm1':minutetohour(d);break;case'm2':return false;break;case'h1':hourtohour(d);break;case'h2':hourtominute(d);break}}else{divnext(d)}break;case 40:if(v){divnext(d)}else{switch(f){case'm1':minutetohour(d);break;case'm2':return false;break;case'h1':hourtohour(d);break;case'h2':hourtominute(d);break}}break;case 13:eval(divtype+'div_click($obj)');break}return false}return false});function errorcheck(){if(o.starthour>=o.endhour){alert('Error - start hour must be less than end hour.');return false}else if(60%o.minutedivisions!=0){alert('Error - param minutedivisions must divide evenly into 60.');return false}}return this}

/*
+-----------------------------------------------------------------------+
| Copyright (c) 2007 Josh Nathanson                  |
| All rights reserved.                                                  |
|                                                                       |
| Redistribution and use in source and binary forms, with or without    |
| modification, are permitted provided that the following conditions    |
| are met:                                                              |
|                                                                       |
| o Redistributions of source code must retain the above copyright      |
|   notice, this list of conditions and the following disclaimer.       |
| o Redistributions in binary form must reproduce the above copyright   |
|   notice, this list of conditions and the following disclaimer in the |
|   documentation and/or other materials provided with the distribution.|
|                                                                       |
| THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   |
| "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT     |
| LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR |
| A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT  |
| OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, |
| SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT      |
| LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, |
| DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY |
| THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT   |
| (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE |
| OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  |
|                                                                       |
+-----------------------------------------------------------------------+
*/