<?php
require_once 'Zend/Controller/Action.php';

/**
 * @category   
 * @package    
 * @copyright
 * @license
 */
abstract class Bullhead_Controller_Action extends Zend_Controller_Action
{
    protected $_config;
    
    protected $_translate;
    
    public function init()
    {
        parent::init();
        
        //設定ファイルの読み込み
    	$config    = $this->_prepareConfig();
    	Zend_Registry::set('config', $config);
    	$this->_config = $config;
    	
    	//翻訳ファイルの読み込み
    	$translate = $this->_prepareTranslate();
    	Zend_Registry::set('Zend_Translate', $translate);
    	$this->_translate = $translate;
    	
    	//データベース接続設定を行う
    	$this->_setupDatabase();
    	
    	//レイアウト設定を行う
    	$this->_setupLayout();
    }
	

	/**
	 * 設定ファイルを読み込む
	 */
	abstract protected function _prepareConfig();

	/**
	 * 翻訳ファイルを読み込む
	 */
	abstract protected function _prepareTranslate();
	
	/**
	 * レイアウト設定を行う
	 */
	abstract protected function _setupLayout();
	
	/**
	 * データベース接続設定を行う
	 */
	abstract protected function _setupDatabase();
    
}