<?php
require_once 'Zend/Log.php';
require_once 'Zend/Log/Writer/Stream.php';

class Bullhead_Log extends Zend_Log
{    
    
    /** Alias Methods **/
    
    /**
     * DEBUG(Lv7)ログを出力する
     * 
     * @param string $message 出力するメッセージ
     */
    public function debug($message)
    {
        $this->log($message, self::DEBUG);
    }
    
    /**
     * INFO(Lv6)ログを出力する
     * 
     * @param string $message 出力するメッセージ
     */
    public function info($message)
    {
        $this->log($message, self::INFO);
    }
    
    /**
     * NOTICE(Lv5)ログを出力する
     * 
     * @param string $message 出力するメッセージ
     */
    public function notice($message)
    {
        $this->log($message, self::NOTICE);
    }
    
    /**
     * WARN(Lv4)ログを出力する
     * 
     * @param string $message 出力するメッセージ
     */
    public function warn($message)
    {
        $this->log($message, self::WARN);
    }
    
    /**
     * ERROR(Lv3)ログを出力する
     * 
     * @param string $message 出力するメッセージ
     */
    public function err($message)
    {
        $this->log($message, self::ERR);
    }
    
    /**
     * CRITICAL(Lv2)ログを出力する
     * 
     * @param string $message 出力するメッセージ
     */
    public function crit($message)
    {
        $this->log($message, self::CRIT);
    }
    
    /**
     * ALERT(Lv1)ログを出力する
     * 
     * @param string $message 出力するメッセージ
     */
    public function alert($message)
    {
        $this->log($message, self::ALERT);
    }
    
    /**
     * EMERGENCY(Lv0)ログを出力する
     * 
     * @param string $message 出力するメッセージ
     */
    public function emerg($message)
    {
        $this->log($message, self::EMERG);
    }
}