<?php
require_once 'Zend/Log.php';
require_once 'Zend/Log/Writer/Stream.php';

class LogWriter
{
    protected $_file;
    
    protected $_logger;
    
    protected static $_logfile;
    
    /**
     * 
     * 
     */
    protected static $_instance;
        
    protected function __construct($file)
    {
        if (!empty($file)) {
            $this->_file = $file;
        }
        
        if (($this->_logger == null) && !empty($this->_file)) {
            $this->_logger = new Zend_Log();
            $this->_logger->addWriter(new Zend_Log_Writer_Stream($this->_file));
        }
    }
    
    public static function getInstance($file=null)
    {
        if (!is_object(self::$_instance)) {
            self::$_instance =& new self($file);
        }
        return self::$_instance;
    }
    
    public static function setDefaultLogFile($file)
    {
        self::$_logfile = $file;
    }
    
    public function debug($message)
    {
        if (!empty($this->_logger)) {
            $this->_logger->log($message, Zend_Log::DEBUG);
        }
    }
    
    public function info($message)
    {
        if (!empty($this->_logger)) {
            $this->_logger->log($message, Zend_Log::INFO);
        }
    }
    
    public function notice($message)
    {
        $this->_logger->log($message, Zend_Log::NOTICE);
    }
    
    public function warn($message)
    {
        if (!empty($this->_logger)) {
            $this->_logger->log($message, Zend_Log::WARN);
        }
    }
    
    public function err($message)
    {
        if (!empty($this->_logger)) {
            $this->_logger->log($message, Zend_Log::ERR);
        }
    }
    
    public function crit($message)
    {
        if (!empty($this->_logger)) {
            $this->_logger->log($message, Zend_Log::CRIT);
        }
    }
    
    public function alert($message)
    {
        if (!empty($this->_logger)) {
            $this->_logger->log($message, Zend_Log::ALERT);
        }
    }
    
    public function emerg($message)
    {
        if (!empty($this->_logger)) {
            $this->_logger->log($message, Zend_Log::EMERG);
        }
    }
}