<?php
require_once 'Zend/Validate/Abstract.php';

class Bullhead_Validate_StringEquals extends Zend_Validate_Abstract {
    
    const NOT_EQUAL = 'stringNotEqual';
    
    protected $_messageTemplates = array(
        self::NOT_EQUAL => ' not equal these string ',
    );
    
    protected $_messageVariables = array(
        'compareValue' => '_compareValue',
    );
    
    protected $_compareValue;

    public function __construct($compareValue = null)
    {
        $this->setCompareValue($compareValue);
    }
    
    public function setCompareValue($compareValue) {
        $this->_compareValue = $compareValue;
    }
    
    public function isValid($value) {
        $value = (string) $value;
        $this->_setValue($value);

        if ($value == $this->_compareValue) {
            return true;
        }

        $this->_error(self::NOT_EQUAL);
        return false;    
    }
}
?>