package ipatjava.analyzer;
import ipatjava.analyzer.scalar.ScalarDataAnalyzer;
import ipatjava.analyzer.scalar.LocalScalarDataAnalyzer;
import ipatjava.data.Data;
import ipatjava.data.term.scalar.ScalarTermData;
import ipatjava.graph.FlowGraph;
import ipatjava.tips.XMLTips;
import ipatjava.tips.XobjectTips;

import java.util.BitSet;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import exc.object.Xcode;

public class OpenMPDirectiveCreator
{    
    final static int PRIVATE_SIZE = 3;
    final static int NORMAL_PRIVATE = 0;
    final static int FIRST_PRIVATE = 1;
    final static int LAST_PRIVATE = 2;
    
    final static String PRIVATE_STRING[] = {"private","firstprivate","lastprivate"};
    
    final static int REDUCTION_SIZE = 7;
    final static String REDUCTION_STRING[] = {"+","-","*","&","|","^"};
    
        
    public OpenMPDirectiveCreator()
    {
    	
    }
    
    public static Element createXMLElement(Document document,LocalScalarDataAnalyzer localScalarDataFlowAnalyzer)	
	{
    	ScalarDataAnalyzer globalScalarDataFlowAnalyzer = localScalarDataFlowAnalyzer.getGlobalScalarDataFlowAnalyzer();
    	FlowGraph flowGraph= globalScalarDataFlowAnalyzer.getFlowGraph();
    	Data currentData = flowGraph.getData();
		BitSet privateList[] = new BitSet[PRIVATE_SIZE];
		BitSet reductionList[] = new BitSet[REDUCTION_SIZE];
    		
        privateList[NORMAL_PRIVATE] = (BitSet)localScalarDataFlowAnalyzer.genInner().clone();
        privateList[NORMAL_PRIVATE].andNot(localScalarDataFlowAnalyzer.reductionOnly());

        for(int i = privateList[NORMAL_PRIVATE].nextSetBit(0) ; i!=-1 ; i=privateList[NORMAL_PRIVATE].nextSetBit(i+1))
        	privateList[NORMAL_PRIVATE].andNot(globalScalarDataFlowAnalyzer.killT()[i]);
                	
        privateList[FIRST_PRIVATE] = (BitSet)localScalarDataFlowAnalyzer.genOuter().clone();
        privateList[FIRST_PRIVATE].and(localScalarDataFlowAnalyzer.udChainInner());
        privateList[FIRST_PRIVATE].andNot(localScalarDataFlowAnalyzer.reductionOnly());

        for(int i = privateList[FIRST_PRIVATE].nextSetBit(0) ; i!=-1 ; i=privateList[FIRST_PRIVATE].nextSetBit(i+1))
        	privateList[FIRST_PRIVATE].andNot(globalScalarDataFlowAnalyzer.killT()[i]);

        privateList[LAST_PRIVATE] = (BitSet) localScalarDataFlowAnalyzer.genInner().clone(); 
        privateList[LAST_PRIVATE].and(localScalarDataFlowAnalyzer.udChainOuter());
        privateList[LAST_PRIVATE].andNot(localScalarDataFlowAnalyzer.reductionOnly());

        for(int i = privateList[LAST_PRIVATE].nextSetBit(0) ; i!=-1 ; i=privateList[LAST_PRIVATE].nextSetBit(i+1))
        	privateList[LAST_PRIVATE].andNot(globalScalarDataFlowAnalyzer.killT()[i]);
        
        for(int i=0;i<REDUCTION_SIZE;reductionList[i++]=new BitSet());

        for(int i = localScalarDataFlowAnalyzer.reductionOnly().nextSetBit(0) ; i != -1 ; i = localScalarDataFlowAnalyzer.reductionOnly().nextSetBit(i+1))
            {
                ScalarTermData std = (ScalarTermData)currentData.getDataList().get(globalScalarDataFlowAnalyzer.getTableDataIndex(i));
                switch(std.getParent().getXobject().Opcode())
                    {
                    case Xcode.ASG_PLUS_EXPR:
                    case Xcode.POST_INCR_EXPR:
                        reductionList[0].set(i);
                        break;
                    case Xcode.ASG_MINUS_EXPR:
                    case Xcode.POST_DECR_EXPR:
                        reductionList[1].set(i);
                        break;
                    case Xcode.ASG_MUL_EXPR:
                        reductionList[3].set(i);
                        break;
                    case Xcode.ASG_BIT_AND_EXPR:
                        reductionList[4].set(i);
                        break;
                    case Xcode.ASG_BIT_OR_EXPR:
                        reductionList[5].set(i);
                        break;
                    case Xcode.ASG_BIT_XOR_EXPR:            
                        reductionList[6].set(i);
                        break;
                    }
            }   

    	Element element = XMLTips.createElement(document,"directive");
        
    	Element openMP = XMLTips.createElement(document,"openmp");
        openMP.setAttribute("type","parallel for");
        openMP.appendChild(XMLTips.lineNo(document,localScalarDataFlowAnalyzer.getTargetData().getLineNo()));

        Element clause = XMLTips.createElement(document,"clause");
  
       for(int i = 0; i < PRIVATE_SIZE ; i++)
            {
                if(i==1)
                    continue;
                if(!privateList[i].isEmpty())
                    {
                	Element privateClause = XMLTips.createElement(document,"private");
                    privateClause.setAttribute("type",PRIVATE_STRING[i]);
                        for(int j = privateList[i].nextSetBit(0) ; j!=-1 ; j = privateList[i].nextSetBit(j+1))
                            {
                        		ScalarTermData scalarTermData = (ScalarTermData)currentData.getDataList().get(globalScalarDataFlowAnalyzer.getTableDataIndex(j));
                        		Element id = XMLTips.createElement(document,"id");
                                id.setAttribute("name",XobjectTips.toString(scalarTermData.getXobject()));
                                privateClause.appendChild(id);
                            }
                        clause.appendChild(privateClause);
                    }
            }

        if(!localScalarDataFlowAnalyzer.reductionOnly().isEmpty())
            {
                for(int i = 0 ; i<REDUCTION_SIZE ; i++)
                    if(!reductionList[i].isEmpty())
                        {
                    	Element reductionClause = XMLTips.createElement(document,"reduction");
                    	reductionClause.setAttribute("op",REDUCTION_STRING[i]);
                    	for(int j = reductionList[i].nextSetBit(0) ; j!=-1 ;j = reductionList[i].nextSetBit(j+1))
                    	{
                    		ScalarTermData scalarTermData = (ScalarTermData)currentData.getDataList().get(globalScalarDataFlowAnalyzer.getTableDataIndex(j));
                    		Element id = XMLTips.createElement(document,"id");
                    		id.setAttribute("name",XobjectTips.toString(scalarTermData.getXobject()));
                    		reductionClause.appendChild(id);
                    	}   
                            clause.appendChild(reductionClause);
                        }	
            }
        openMP.appendChild(clause);
        element.appendChild(openMP);
        return element;
    }
}
