package ipatjava.analyzer;
import ipatjava.analyzer.block.ForBlockParallelismAnalyzer;
import ipatjava.data.Data;
import ipatjava.data.block.ForBlockData;

import java.util.ListIterator;

import org.w3c.dom.Document;
import org.w3c.dom.Element;


public class ParallelismAnalyzer
{
	protected ProgramAnalyzer programAnalyzer;
	protected Data data;
	
    public ParallelismAnalyzer(Data data,Document document)
    {
    	this.data = data;
    	this.programAnalyzer = new ProgramAnalyzer(data);
    	analyze(document);
    }
    
    private void analyze(Document document)
    {
    	Element	rootElement = document.getDocumentElement();
    	
	for(ListIterator li1 = this.data.getDataList().listIterator();li1.hasNext();)
	    {
		Data data1 = (Data)li1.next();
		if(data1 instanceof ForBlockData)
		{
			ForBlockParallelismAnalyzer forBlockParallelismAnalyzer = new ForBlockParallelismAnalyzer(this.programAnalyzer,(ForBlockData)data1);
			rootElement.appendChild(forBlockParallelismAnalyzer.getAnalysisResultElement(document));
							}
		    	    }
    }
}
