package ipatjava.analyzer.array;

import ipatjava.analyzer.LocalDataAnalyzer;
import ipatjava.data.Data;

import java.util.BitSet;

public class LocalArrayDataAnalyzer extends LocalDataAnalyzer
{
	ArrayDataAnalyzer arrayDataAnalyzer;
	BitSet outputInner[];
	BitSet outputOuter[];
	BitSet flowAntiInner[];
	BitSet flowAntiOuter[];
	BitSet inputInner[];
	BitSet inputOuter[];
	
    public LocalArrayDataAnalyzer(ArrayDataAnalyzer arrayDataAnalyzer,Data targetData)
    {
    	super(arrayDataAnalyzer,targetData);
    	this.arrayDataAnalyzer = arrayDataAnalyzer;
    	int tableSize= this.arrayDataAnalyzer.getDataTable().cardinality();
    	    	
    	this.calcInner();
    	this.calcOuter();
    }
    
    private void calcInner()
    {
    	int size =  this.arrayDataAnalyzer.getDataTable().cardinality();
    	outputInner = new BitSet[size];
    	flowAntiInner = new BitSet[size];
    	inputInner = new BitSet[size];
    	for(int i=super.tableInner.nextSetBit(0);i!=-1;i=super.tableInner.nextSetBit(i+1))
    	{
    		BitSet tmp1 = (BitSet)this.arrayDataAnalyzer.output()[i].clone();
    		tmp1.and(super.tableInner);
    		outputInner[i]=(BitSet)tmp1.clone();
    		
    		BitSet tmp2 = (BitSet)this.arrayDataAnalyzer.flowAnti()[i].clone();
    		tmp2.and(super.tableInner);
    		flowAntiInner[i]=(BitSet)tmp2.clone();

    		BitSet tmp3 = (BitSet)this.arrayDataAnalyzer.input()[i].clone();
    		tmp3.and(super.tableInner);
    		inputInner[i]=(BitSet)tmp3.clone();
    	}
    }
    public BitSet[] outputInner(){return outputInner;}
    public BitSet[] flowAntiInner(){return flowAntiInner;}
    public BitSet[] inputInner(){return inputInner;}
    private void calcOuter()
    {
    	
    }

}
