package ipatjava.data.block;
import ipatjava.data.expr.AsignExprData;
import ipatjava.tips.XMLTips;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import exc.block.CondBlock;
import exc.block.ForBlock;

public class ForBlockData extends CondBlockData
{
    protected BasicBlockData iter;
    protected BasicBlockData init;

    protected AsignExprData initExpr=null;
    protected AsignExprData iterExpr=null;

    public ForBlockData(ForBlock forBlock,BlockListData parent)
    {
	super((CondBlock)forBlock,parent);

	this.init = new BasicBlockData(forBlock.getInitBBlock(),forBlock.getInitBBlock().getParent().getLineNo(),this);
	this.iter = new BasicBlockData(forBlock.getIterBBlock(),forBlock.getInitBBlock().getParent().getLineNo(),this);

	super.mergeDataList(this.init);
	super.mergeDataList(super.cond);
	super.mergeDataList(super.body);
	super.mergeDataList(this.iter);

	this.init.getStatementDataSocket().connectEachOther(super.cond.getStatementDataSocket());
	super.cond.getStatementDataSocket().connectEachOther(super.body.getStatementDataSocket());
	super.body.getStatementDataSocket().connectEachOther(this.iter.getStatementDataSocket());
	this.iter.getStatementDataSocket().connectEachOther(super.cond.getStatementDataSocket());

	statementDataSocket.setHead(this.init.getStatementDataSocket().getHead());
	statementDataSocket.setTail(super.cond.getStatementDataSocket().getTail());

	if(this.init.getStatementDataSocket().getHead().isEmpty())
	    statementDataSocket.setHead(this.cond.getStatementDataSocket().getHead());

	if(super.getStatementDataSocket().getHead().isEmpty())
	    {
		if(!this.iter.getStatementDataSocket().getHead().isEmpty())
		    super.cond.getStatementDataSocket().connectEachOther(this.iter.getStatementDataSocket());
		else
		    super.cond.getStatementDataSocket().connectEachOther(super.cond.getStatementDataSocket());
	    }

	super.setJumpStatement(this.iter);
    }

    public BasicBlockData getInit(){return this.init;}
    public BasicBlockData getIter(){return this.iter;}

    public Element getXMLElement(Document document)
    {
        Element element = XMLTips.createElement(document,"block");
        element.setAttribute("source",super.getLineNo().fileName());
        element.setAttribute("lineno",Integer.toString(super.getLineNo().lineNo()));
        element.setAttribute("type","for");
        return element;
    }
}
