package ipatjava.data.term.function;
import ipatjava.data.Data;
import ipatjava.data.term.TermData;
import ipatjava.tips.XMLTips;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import exc.object.LineNo;
import exc.object.Xobject;

public class FunctionTermData extends TermData
{
        Xobject functionName = null;

    public FunctionTermData(Xobject term,LineNo lineNo,Data parent)
    {
	super(term,lineNo,parent);
	this.functionName = term.left();
    }
    public Xobject getFunctionName(){return this.functionName;}

    public Element getXMLElement(Document document)
    {
        Element element = XMLTips.createElement(document,"data");
        element.setAttribute("source",super.getLineNo().fileName());
        element.setAttribute("lineno",Integer.toString(super.getLineNo().lineNo()));
        element.setAttribute("type","FunctionCall");
        element.setAttribute("name",this.getFunctionName().getName());
        return element;
    }

}
