package ipatjava.measure;
import ipatjava.data.Data;
import ipatjava.data.block.BlockData;
import ipatjava.data.block.ForBlockData;
import ipatjava.data.block.FunctionBlockData;
import ipatjava.data.block.ReturnStatementData;
import ipatjava.data.block.StatementData;
import ipatjava.data.term.function.FunctionTermData;
import ipatjava.tips.XMLTips;

import java.util.BitSet;
import java.util.ListIterator;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.FunctionBlock;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectDefVisitor;
import exc.object.Xtype;


public class MeasureFunctionBlocks implements XobjectDefVisitor
{
	final static int REGION_START = 0;
	final static int REGION_END = 1;
	
	String functionName = null;
    Document document;
	
    int globalCounter=1;
    private Xobject mainStart = Xcons.Symbol(Xcode.FUNC_ADDR,Xtype.Pointer(Xtype.Function(Xtype.voidType)),"_ipat_time_measurement_init_");
    private Xobject measureFunc = Xcons.Symbol(Xcode.FUNC_ADDR,Xtype.Pointer(Xtype.Function(Xtype.voidType))," _ipat_stamp_time_");
    private Xobject mainEnd = Xcons.Symbol(Xcode.FUNC_ADDR,Xtype.Pointer(Xtype.Function(Xtype.voidType)),"_ipat_time_measurement_finalize_");
    Xobject start =  Xcons.IntConstant(REGION_START);
    Xobject end =  Xcons.IntConstant(REGION_END);

    public MeasureFunctionBlocks(Document document)
    {
    	this.document = document;
    }
    
    public void doDef(XobjectDef def)
    { 
  	if(def.isFuncDef())
	    {
		functionName = Bcons.buildFunctionBlock(def).getName();
		Element element = this.addMeasureFunc(def);
		this.document.getDocumentElement().appendChild(element);
	    }	
    }
    
    public Element addMeasureFunc(XobjectDef def)
    {
	FunctionBlock functionBlock = Bcons.buildFunctionBlock(def);
	Block block = functionBlock.getBody().getHead();
	FunctionBlockData functionBlockData = new FunctionBlockData(functionBlock,null);
	functionBlockData.setDataRelation();
	Element rootElement = XMLTips.createElement(document,"point");
		
	int current = 0;
	Element functionElement = functionBlockData.getXMLElement(this.document);

	if(functionBlock.getName()=="main")
	    {
		functionElement.setAttribute("ObjectNumber",Integer.toString(0));
		XobjList list = new XobjList();
		list.add(new XobjString(Xcode.STRING_CONSTANT,def.getFile().getSourceFileName()));
		block.getBody().insert(Xcons.functionCall(mainStart,list));
		block.getBody().add(Xcons.functionCall(mainEnd,new XobjList()));
	    }
	else
	    {
		current = globalCounter;
		functionElement.setAttribute("ObjectNumber",Integer.toString(current));
		XobjList list0 = new XobjList();
		list0.add(Xcons.IntConstant(globalCounter));
		list0.add(start);
		block.getBody().insert(Xcons.functionCall(measureFunc,list0));
		XobjList list1 = new XobjList();
		list1.add(Xcons.IntConstant(globalCounter));
		list1.add(end);
		block.getBody().add(Xcons.functionCall(measureFunc,list1));
		globalCounter++;
	    }
	rootElement.appendChild(functionElement);
		for(ListIterator listIterator = functionBlockData.getDataList().listIterator();listIterator.hasNext();)
	{
		Data data = (Data)listIterator.next();
		if(data instanceof ForBlockData)
		{
			Element forElement = ((ForBlockData)data).getXMLElement(this.document);
			forElement.setAttribute("ObjectNumber",Integer.toString(globalCounter));
			rootElement.appendChild(forElement);
			XobjList list0 = new XobjList();
			list0.add(Xcons.IntConstant(globalCounter));
			list0.add(start);
			((BlockData)data).getBlock().insert(Xcons.functionCall(measureFunc,list0));
			XobjList list1 = new XobjList();
			list1.add(Xcons.IntConstant(globalCounter));
		list1.add(end);
		block.add(Xcons.functionCall(measureFunc,list1));
		((BlockData)data).getBlock().add(Xcons.functionCall(measureFunc,list1));
		
		globalCounter++; 
		
		continue;
		}
		if(data instanceof ReturnStatementData)
		{
			
			if(current==0)
			    ((BlockData)data).getBlock().insert(Xcons.functionCall(mainEnd,new XobjList()));
			else
			    {
				XobjList list = new XobjList();
				list.add(Xcons.IntConstant(current));
				list.add(end);
				((BlockData)data).getBlock().insert(Xcons.functionCall(measureFunc,list));
			    }
			continue;
		}
		if(data instanceof FunctionTermData)
		{
			String name = ((FunctionTermData)data).getFunctionName().getString();
			if(name.equals("exit"))
			{
				BitSet bitSet = data.getParentDataIndex();
				int last = -1;
				for(int i = bitSet.nextSetBit(0) ; i!=-1; i=bitSet.nextSetBit(i+1))
				{
					Data data2 = functionBlockData.getData(i);
					if(data2 instanceof StatementData)
						last = i;
				}
				if(last!=-1)
				{
				Data data2 = functionBlockData.getData(last);
				((StatementData)data2).getStatement().insert(Xcons.functionCall(mainEnd,new XobjList()));
				}
			}
		}
	}
	def.setDef(functionBlock.toXobject());
	return rootElement;
    }
}
