package ipatjava.parallelizer;
import ipatjava.analyzer.ParallelismAnalyzer;
import ipatjava.data.FunctionBlocks;
import ipatjava.data.block.FunctionBlockData;
import ipatjava.tips.XMLTips;

import java.io.File;
import java.util.List;
import java.util.ListIterator;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import exc.block.Bcons;
import exc.object.XobjectDef;
import exc.object.XobjectFile;

public class Parallelizer
{
    public static void main(String args[]){
	
	String infile = null;
	String funcname = null;
	String xmlName = "ipat_result.xml";

	int argc = 0;
	int range[] = {0,Integer.MAX_VALUE};
	while(argc<args.length)
	    {
		if(args[argc].substring(0,1).equals("-"))
		    {
			String arg = args[argc].substring(1);
			if(arg.equals("l"))
			    {
				argc++;
				for(int i = 0 ; i < 2 ; i++)
				    try{
					range[i] = Integer.parseInt(args[argc]);
					argc++;
				    }catch (NumberFormatException e)
					{
					    usage("-l:invalid args (isn't number)\n");
					}
				    catch (ArrayIndexOutOfBoundsException e)
					{
					    usage("-l:invalid Arg\n");
					}
				continue;
			    }
			if(arg.equals("o"))
			    {
				argc++;
				try{
				    xmlName=args[argc];
				    argc++;
				}
				catch (ArrayIndexOutOfBoundsException e)
				    {
					usage("-o:invalid Arg\n");
				    }
				continue;
			    }
			if(arg.equals("f"))
			    {
				argc++;
				try{
				    funcname=args[argc];
				    argc++;
				}
				catch (ArrayIndexOutOfBoundsException e)
				    {
					usage("-f:invalid Arg\n");
				    }
				continue;
			    }
		    }
		else if(argc == args.length-1)
		    infile = args[argc];
		argc++;
	    }

	if(infile==null)
	    usage("Please imput file name.\n");

	File check_f = new File(infile);
	if(!check_f.exists())
	    usage("cannot open file '"+infile+"'\n");   

	XobjectFile xobjectFile = new XobjectFile(infile,null);
	FunctionBlocks functionBlocks = new FunctionBlocks();	

	xobjectFile.Input();
	xobjectFile.iterateDef(functionBlocks);
	
	List functionNameList = functionBlocks.getNameList();
	Document document = XMLTips.createDocument(); 
	Element rootElement =XMLTips.createElement(document,"analysis_results");
	document.appendChild(rootElement);

	for(ListIterator li = functionNameList.listIterator() ; li.hasNext() ; )
	    {
		String functionName = (String)li.next();
		XobjectDef def = functionBlocks.getFunctionDef(functionName);
		if(def!=null)
		    {
			FunctionBlockData functionBlockData =  new FunctionBlockData(Bcons.buildFunctionBlock(def),null);
			ParallelismAnalyzer pAnalyzer = new ParallelismAnalyzer(functionBlockData,document);
		    }
	    }

	XMLTips.writeDocument(document,xmlName);	
	
	

	//	xobjectFile.Decompile("uhihi.c");
    }
    private static void usage(String str)
    {
	System.out.print(str);
	System.out.print("\n");
	System.out.print("Panalysis [options] xobject_file_name \n");
	System.out.print("options are:\n");
	System.out.print("-l: set analysis area\n");
	System.out.print("-f: set functions analyzed by iPat/OMP\n");
	System.out.print("-p: set default clause 'private'\n");
	System.out.print("-s: set default clause 'shared'\n");
	System.out.print("\n");	
	System.exit(-1);
    } 
}
