package ipatjava.tips;
import exc.object.*;

public class XobjectTips
{
    public static boolean sameXobject(Xobject x1,Xobject x2)
    {
	if(x1==null)
	    return false;
	if(x2==null)
	    return false;

	if(x1.Opcode() != x2.Opcode())
	    return false;
	
	switch(x1.Opcode())
	    {
	    case Xcode.LIST:
		boolean result = true;
		XobjArgs xa2 = x2.getArgs();
		XobjArgs xa1 = x1.getArgs();
		while(xa1 !=null && xa2 != null)
		    {
			result = result && XobjectTips.sameXobject(xa1.getArg(),xa2.getArg()); 
			xa1 = xa1.nextArgs();
			xa2 = xa2.nextArgs();
		    }
		return result;
	    case Xcode.POINTER_REF:	
	    case Xcode.PLUS_EXPR:	
	    case Xcode.MINUS_EXPR:	
	    case Xcode.DIV_EXPR:	
	    case Xcode.MUL_EXPR:	
		return XobjectTips.sameXobject(x1.left(),x2.left()); 
	    case Xcode.LVAR_ADDR:
	    case Xcode.VAR_ADDR:
	    case Xcode.PARAM_ADDR:
	    case Xcode.LARRAY_ADDR:
	    case Xcode.ARRAY_ADDR:
	    case Xcode.IDENT:
	    case Xcode.INT_CONSTANT:
	    case Xcode.LONG_CONSTANT:
	    case Xcode.FLOAT_CONSTANT:
	    case Xcode.LONGLONG_CONSTANT:
		return x1.getName().equals(x2.getName());
	    case Xcode.MEMBER_ADDR:
	    case Xcode.MEMBER_ARRAY_ADDR:
		return  XobjectTips.sameXobject(x1.left(),x2.left()) && XobjectTips.sameXobject(x1.right(),x2.right());
	    default:
		return false;
	    }
    }

    public static String toString(Xobject x)
    {
	StringBuffer sb = new StringBuffer();
	switch(x.Opcode())
	    {
	    case Xcode.POINTER_REF:
		sb.append(XobjectTips.toString(x.left()));
		break;
	    case Xcode.ARRAY_AREF:
		sb.append(XobjectTips.toString(x.left()));
		break;		
	    case Xcode.MEMBER_ADDR:
	    case Xcode.MEMBER_ARRAY_ADDR:
		if(x.left().Opcode() == Xcode.POINTER_REF)
		    {
			sb.append(XobjectTips.toString(x.left()));
			sb.append("->");
			sb.append(XobjectTips.toString(x.right()));
		    }
		else
		    {
			sb.append(XobjectTips.toString(x.left()));
			sb.append(".");
			sb.append(XobjectTips.toString(x.right()));			
		    }
		break;
	    case Xcode.PLUS_EXPR:	
		switch(x.left().Opcode())
		    {
		    case Xcode.ARRAY_AREF:
		    case Xcode.ARRAY_ADDR:
		    case Xcode.LARRAY_ADDR:
		    case Xcode.VAR_ADDR:
		    case Xcode.LVAR_ADDR:
		    case Xcode.MEMBER_ARRAY_ADDR:
			sb.append(XobjectTips.toString(x.left()));
			sb.append("[");
			sb.append(XobjectTips.toString(x.right()));
			sb.append("]");
			break;	
		    default:
			sb.append(XobjectTips.toString(x.left()));
			sb.append("+");
			sb.append(XobjectTips.toString(x.right()));			
		    }
		break;
	    case Xcode.MINUS_EXPR:	
		sb.append(XobjectTips.toString(x.left()));
		sb.append("-");
		sb.append(XobjectTips.toString(x.right()));	
		break;
	    case Xcode.DIV_EXPR:	
		sb.append(XobjectTips.toString(x.left()));
		sb.append("/");
		sb.append(XobjectTips.toString(x.right()));	
		break;
	    case Xcode.MUL_EXPR:
		switch(x.left().Opcode())
		    {
		    case Xcode.PLUS_EXPR:
		    case Xcode.MINUS_EXPR:
			sb.append("(");
			sb.append(XobjectTips.toString(x.left()));
			sb.append(")");
		    default:
			sb.append(XobjectTips.toString(x.left()));
			break;
		    }		
		sb.append("*");
		switch(x.left().Opcode())
		    {
		    case Xcode.PLUS_EXPR:
		    case Xcode.MINUS_EXPR:
			sb.append("(");
			sb.append(XobjectTips.toString(x.right()));
			sb.append(")");
		    default:
			sb.append(XobjectTips.toString(x.right()));
			break;
		    }		
		break;
	    case Xcode.LVAR_ADDR:
	    case Xcode.VAR_ADDR:
	    case Xcode.PARAM_ADDR:
	    case Xcode.LARRAY_ADDR:
	    case Xcode.ARRAY_ADDR:
	    case Xcode.IDENT:
	    case Xcode.INT_CONSTANT:
	    case Xcode.LONG_CONSTANT:
	    case Xcode.FLOAT_CONSTANT:
	    case Xcode.LONGLONG_CONSTANT:
		return x.getName();
	    }		
	return sb.toString();
    }

    public static XobjList deconstructExpr(Xobject expr,XobjList result)
    {
	if(expr == null || expr.isTerminal())
	    return result;
	
	XobjList xobjList;

	if(expr.Opcode() == Xcode.COMMA_EXPR)
	    for(XobjArgs args = expr.getArgs() ; args !=null ; args = args.nextArgs())
		{
		    Xobject arg = args.getArg();
		    XobjectTips.deconstructExpr(arg,result);
		}
	else
	    for(XobjArgs args = expr.getArgs() ; args !=null ; args = args.nextArgs())
		{
		    Xobject arg = args.getArg();
		    XobjectTips.deconstructExpr(arg,result);
		    if(arg != null)
			switch(arg.Opcode())
			    {
			    case Xcode.POST_INCR_EXPR:      
			    case Xcode.POST_DECR_EXPR:
				result.add(arg.copy());
				args.setArg(arg.left());
				break;
			    case Xcode.ASSIGN_EXPR:
			    case Xcode.ASG_PLUS_EXPR:
			    case Xcode.ASG_MINUS_EXPR:
			    case Xcode.ASG_MUL_EXPR:
			    case Xcode.ASG_DIV_EXPR:
			    case Xcode.ASG_MOD_EXPR:
			    case Xcode.ASG_BIT_AND_EXPR:
			    case Xcode.ASG_LSHIFT_EXPR:
			    case Xcode.ASG_RSHIFT_EXPR:
			    case Xcode.ASG_BIT_OR_EXPR:
			    case Xcode.ASG_BIT_XOR_EXPR:
				result.add(arg.copy());
				args.setArg(arg.right());
				break;
			    }
		}
	return result;
    }

    public static Xobject changeExpr(Xobject expr)
    {
	Xobject tmp = XobjectTips.changeAsgExpr(expr);
	return tmp;
    }

    public static Xobject changeAsgExpr(Xobject expr)
    {
	Xobject tmp = expr;
	if(tmp.Opcode() == Xcode.ASSIGN_EXPR)
	    switch(tmp.right().Opcode())
		{
		case Xcode.PLUS_EXPR:
		case Xcode.MINUS_EXPR:
		case Xcode.MUL_EXPR:
		case Xcode.DIV_EXPR:
		case Xcode.MOD_EXPR:
		case Xcode.LSHIFT_EXPR:
		case Xcode.RSHIFT_EXPR:
		case Xcode.BIT_AND_EXPR:
		case Xcode.BIT_OR_EXPR:
		case Xcode.BIT_XOR_EXPR:
		    if(XobjectTips.sameXobject(tmp.left(),tmp.right().left()))
			tmp = Xcons.asgOp(tmp.right().Opcode()+1, tmp.left(),tmp.right().right());
		    break;
		default:
		    return tmp;
		}
	return tmp;
    }
}    

