#include "libipat.h"

void change_endian_double(double *d)
{
  double s=*d;
  char *ps=((char*)&s), *pd=((char*)d);
  pd[0] = ps[7]; 
  pd[1] = ps[6]; 
  pd[2] = ps[5]; 
  pd[3] = ps[4]; 
  pd[4] = ps[3]; 
  pd[5] = ps[2]; 
  pd[6] = ps[1]; 
  pd[7] = ps[0]; 
}

void change_endian_int(int *d)
{
  int s=*d;
  char *ps=((char*)&s), *pd=((char*)d);
  pd[0] = ps[3]; 
  pd[1] = ps[2]; 
  pd[2] = ps[1]; 
  pd[3] = ps[0]; 
}

void change_endian_short(short *d)
{
  short s=*d;
  char *ps=((char*)&s), *pd=((char*)d);
  pd[0] = ps[1]; 
  pd[1] = ps[0]; 
}

void _ipat_time_measurement_init_(char *fname)
{
  __ipat_time_info__ = (struct _ipat_time_info *)malloc(sizeof(struct _ipat_time_info));
  __ipat_current_time_stamp__ = (struct _ipat_time_stamp_ *)malloc(sizeof(struct _ipat_time_stamp_));
  char filename[1024];
  void _ipat_time_measurement_finalize_();

  fprintf(stderr,"start to measure the execution.\n");

  if(signal(SIGINT,_ipat_time_measurement_finalize_)==SIG_ERR)
    {
      perror("signal");
      exit(1);
    }

  gettimeofday(&(__ipat_current_time_stamp__->time),&tz);
  __ipat_time_info__->myrank=0;
  __ipat_time_info__->next=__ipat_current_time_stamp__;

  __ipat_time_info__->next->objno=0;
  __ipat_time_info__->next->status=0;

  sprintf(filename,"%s.log",fname);
  printf("%s\n",filename);
  __ipat_time_info__->file=fopen(filename,"wb");
}

void _ipat_time_measurement_finalize_()
{
  fprintf(stderr,"end to measure the execution.\n");
  _ipat_stamp_time_(0,1);
  _ipat_write_time_measurement_result_();
  fclose(__ipat_time_info__->file);
  exit(0);
}

void _ipat_write_time_measurement_result_()
{
  double sec;
  __ipat_current_time_stamp__=__ipat_time_info__->next;
  while(1)
    {
      sec=(double)(__ipat_current_time_stamp__->time.tv_usec - __ipat_time_info__->next->time.tv_usec);
      sec/= 1000000.0;
      sec+=(double)(__ipat_current_time_stamp__->time.tv_sec - __ipat_time_info__->next->time.tv_sec);
      change_endian_double(&sec);
      fwrite(&sec,sizeof(double),1,__ipat_time_info__->file);
      change_endian_short(&__ipat_time_info__->myrank);
      fwrite(&__ipat_time_info__->myrank,sizeof(short),1,__ipat_time_info__->file);
      change_endian_int(&__ipat_current_time_stamp__->objno);
      fwrite(&__ipat_current_time_stamp__->objno,sizeof( int),1,__ipat_time_info__->file);
      change_endian_short(&__ipat_current_time_stamp__->status);
      fwrite(&__ipat_current_time_stamp__->status,sizeof( short),1,__ipat_time_info__->file);
      __ipat_current_time_stamp__=__ipat_current_time_stamp__->next;
      if(__ipat_current_time_stamp__==NULL)break;
    }
}

void _ipat_stamp_time_( int objno, short status)
{
  struct _ipat_time_stamp_ *next_time = (struct _ipat_time_stamp_ *)malloc(sizeof(struct _ipat_time_stamp_));
  
  gettimeofday(&(next_time->time),&tz);
  next_time->objno=objno;
  next_time->status=status;

  __ipat_current_time_stamp__->next=next_time;
  __ipat_current_time_stamp__=next_time;
}
