<?php
/**
 * ホテル設定
 *
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Hotel extends ADMIN_Controller {

    function Hotel()
    {
        parent::ADMIN_Controller();
    }
    
    public function index()
    {
        // breadcrumb [admin] -> [hotel]
        
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->load->library('phpsession');
        
        $this->form_validation->set_rules('hotel_name', 'ホテル名', 'required');
        $this->form_validation->set_rules('email', 'メールアドレス', 'required');
        $this->form_validation->set_rules('url', 'URL', '');
        
        
        
        $this->form_validation->set_rules('res1_mail', '仮予約メール', '');
        $this->form_validation->set_rules('res2_mail', '本予約メール', '');
        $this->form_validation->set_rules('res_cancel_mail', '予約キャンセルメール', '');
        
        $hotelid = 1;
        
        if (!$this->input->post('submit'))
        {
            $this->db->where('hotelid', $hotelid);
            $query = $this->db->get('hotel', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $data['hotel_name'] = $row['hotel_name'];
                $data['email'] = $row['email'];
                $data['url'] = $row['url'];
                $data['res1_mail'] = $row['res1_mail'];
                $data['res2_mail'] = $row['res2_mail'];
                $data['res_cancel_mail'] = $row['res_cancel_mail'];
                $this->load->vars($data);
            }
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('admin/hotel/index');
        }
        else
        {
            $data = array(
                           'hotel_name' => set_value('hotel_name'),
                           'email' => set_value('email'),
                           'url' => set_value('url'),
                           'res1_mail' => set_value('res1_mail'),
                           'res2_mail' => set_value('res2_mail'),
                           'res_cancel_mail' => set_value('res_cancel_mail')
                        );
                        
            $this->db->where('hotelid', $hotelid);
            $query = $this->db->get('hotel', 1);
            if ($query->num_rows() > 0)
            {
                $this->db->where('hotelid', $hotelid);
                $this->db->update('hotel', $data);
            }
            else
            {
                $data = array(
                               'hotelid' => $hotelid,
                               'hotel_name' => set_value('hotel_name'),
                               'email' => set_value('email'),
                               'url' => set_value('url'),
                               'res1_mail' => set_value('res1_mail'),
                               'res2_mail' => set_value('res2_mail'),
                               'res_cancel_mail' => set_value('res_cancel_mail')
                            );
                $this->db->insert('hotel', $data);
            }
            $this->load->view('admin/hotel/index');
        }
    }
    
    public function email()
    {
        // breadcrumb [admin] -> [hotel] -> [email]
        $this->load->view('admin/hotel/email');
    }
}
