<?php
/**
 * Admin Res
 * @package     hotel reservation system
 * @author      Teruki Hosokawa <hosotk@gmail.com>
 * @license     New BSD Licence
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Res extends ADMIN_Controller {

    function Res()
    {
        parent::ADMIN_Controller();
        $this->load->helper(array('form', 'url'));
        $this->load->model('User_model');
        if ($this->User_model->isAdmin() != true)
        {
            redirect('admin/login/index');
        }
        $this->load->model('Res_model');
        $this->load->model('Hotel_model');
    }
    
    /**
     * \ꗗ
     */
    public function index()
    {
        $this->load->helper(array('form', 'url'));
        $this->db->order_by('created DESC');
        $query = $this->db->get('reservation');
        $data['ress'] = $query->result_array();
        //var_dump($data);
        //$data['title'] = "Plans";
        //$data['headline'] = "";
        $this->load->vars($data);
        $this->load->view('admin/res/index');
    }
    
    /**
     * \ڍ
     */
    public function detail($resid)
    {
        $this->load->helper(array('form', 'url'));
        
        $data['title'] = "Res";
        $data['headline'] = "";
        
        $this->db->where('resid', $resid);
        $query = $this->db->get('reservation', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
        }
        $data['resid'] = $resid;
        $this->load->vars($data);
        
        $this->load->view('admin/res/detail');
    }
    
    /**
     * \Xe[^XύXB
     * ύXA\ڍ׉ʂɑJڂB
     */
    public function changeStatus($resid, $new_status)
    {
        $this->load->helper(array('form', 'url'));
        
        $this->db->where('resid', $resid);
        $query = $this->db->get('reservation', 1);
        if ($query->num_rows() <= 0)
        {
            return;
        }
        
        $row = $query->row_array();
        $status = $row['status'];
        
        if ($new_status == 2)
        {
            /**
             * \->{\
             */
            $this->Res_model->confirmRes($resid, $this->Hotel_model);
        }
        else if ($new_status == 0)
        {
            if ($status == 1)
            {
                // \ -> LZ
                $this->Res_model->cancel($resid, 2, $this->Hotel_model);
            }
            else if ($status == 2)
            {
                // {\ -> LZ
                $this->Res_model->cancel($resid, 3, $this->Hotel_model);
            }
        }
        
        redirect('admin/res/detail/' . $resid);
    }
}
/* End of file res.php */
