<?php
/**
 * Plans
 */
class Plans extends MY_Controller {

    function Plans()
    {
        parent::MY_Controller();
    }
    
    function index()
    {
        $this->load->helper(array('form', 'url'));
        
        $this->db->select('*');
        $this->db->from('plans');
        $this->db->join('planprice', 'planprice.planid = plans.planid');
        $query = $this->db->get();
        
        $data['plans'] = $query->result_array();
        $data['title'] = "Plans";
        $data['headline'] = "";
        $this->load->vars($data);
        
        $this->load->view('plans/index');
    }
    
    /**
     * プラン詳細
     */
    function detail($planid)
    {
        $this->load->helper(array('form', 'url'));
        
        $data['title'] = "Plans";
        $data['headline'] = "";
        
        $this->db->select('*');
        $this->db->from('plans');
        $this->db->join('planprice', 'planprice.planid = plans.planid');
        $query = $this->db->get();
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
        }
        $data['planid'] = $planid;
        $this->load->vars($data);
        
        $this->load->view('plans/detail');
    }
    
    /**
     * プラン空きカレンダー表示
     * @param $planid
     * @param $d        yyyymm
     */
    function vacantplans($planid, $year, $month)
    {
        $this->load->helper('url');
        
        // プラン情報取得
        $this->db->where('planid', $planid);
        $query = $this->db->get('plans', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $this->load->vars($row);
            $roomtypeid = $row['roomtypeid'];
        }
        else
        {
            die();
        }
        
        ob_start();
        
        $prefs = array (
                       'show_next_prev'  => TRUE,
                       'next_prev_url'   => site_url('plans/vacantplans/' . $planid)
                     );
        
        $prefs['template'] = '
           {table_open}<table width="100%" border="1px" cellpadding="0" cellspacing="0">{/table_open}
           {heading_row_start}<tr>{/heading_row_start}
           {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
           {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
           {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}
           {heading_row_end}</tr>{/heading_row_end}
           {week_row_start}<tr>{/week_row_start}
           {week_day_cell}<td>{week_day}</td>{/week_day_cell}
           {week_row_end}</tr>{/week_row_end}
           {cal_row_start}<tr>{/cal_row_start}
           {cal_cell_start}<td>{/cal_cell_start}
           {cal_cell_content}{day}<br />{content}{/cal_cell_content}
           {cal_cell_content_today}<div class="highlight">{day}<br />{content}</div>{/cal_cell_content_today}
           {cal_cell_no_content}{day}{/cal_cell_no_content}
           {cal_cell_no_content_today}<div class="highlight">{day}</br /></div>{/cal_cell_no_content_today}
           {cal_cell_blank}&nbsp;{/cal_cell_blank}
           {cal_cell_end}</td>{/cal_cell_end}
           {cal_row_end}</tr>{/cal_row_end}
           {table_close}</table>{/table_close}
        ';
        
        $this->load->library('calendar', $prefs);
        
        $cal_data = array();
        
        // 月の日数
        $days = date('t', mktime(0, 0, 0, $month, 1, $year));
        
        $today = date("Ymd");
        
        for ($i = 1; $i <= $days; $i++)
        {
            // 予約受付範囲内であるか？
            $d = sprintf('%04d%02d%02d', $year, $month, $i);
            if ($today > $d)
            {
                // 今日より前
                $cal_data[$i] = "<br /><br /><br />";
                continue;
            }
            
            $celldata = '';
            $v_plan = 0;
            $v_room = 0;
            
            // 空きプラン人数
            $this->db->where('planid', $planid);
            $this->db->where('day', $year . $month . sprintf("%02d", $i));
            $query = $this->db->get('vacantplans', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $v_plan = $row['num'];
            }
            
            
            // 空き部屋数
            $this->db->where('roomtypeid', $roomtypeid);
            $this->db->where('day', $year . $month . sprintf("%02d", $i));
            $query = $this->db->get('vacantrooms', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $v_room = $row['num'];
            }
            
            // 日程
            $daytype = 'A';
            $this->db->where('day', sprintf("%04d-%02d-%02d", $year, $month, $i));
            $query = $this->db->get('daytype', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $daytype = $row['value'];
            }
            
            if ($v_plan > 0 && $v_room > 0)
            {
                $url = sprintf("%d/%04d%02d%02d", $planid, $year, $month, $i);
                
                // 料金
                $planprice = 0;
                $this->db->where('planid', $planid);
                $query = $this->db->get('planprice', 1);
                if ($query->num_rows() > 0)
                {
                    $row = $query->row_array();
                    switch ($daytype)
                    {
                        case 'A':
                            $planprice = $row['a_basic_price'];
                            break;
                        case 'B':
                            $planprice = $row['b_basic_price'];
                            break;
                        case 'C':
                            $planprice = $row['c_basic_price'];
                            break;
                        case 'D':
                            $planprice = $row['d_basic_price'];
                            break;
                    }
                }
                
                $sss = '<a href="' . site_url('res/index/' . $url) . '">'
                   . $v_plan . '人' . "<br />"
                   . $v_room . '部屋' . "<br />"
                   . number_format($planprice) . "円～"
                   . '</a>';
                $cal_data[$i] = $sss;
            }
            else
            {
                $cal_data[$i] = "<br /><br /><br />";
            }
            

            

        }
        
        echo $this->calendar->generate($this->uri->segment(4), $this->uri->segment(5), $cal_data);
        
        echo "<br />";
        
        
        $data['contents'] = ob_get_contents();
        ob_end_clean();
        $this->load->vars($data);
        
        $this->load->view('plans/vacantplans');
    }
}
