<?php
/**
 *  ユーザ手続き
 * refs
 * ci-cms member.php
 */
class Users extends MY_Controller {

    function Users()
    {
        parent::MY_Controller();
        //$this->load->model('user_model');
        $this->load->model('Res_model');
    }
    
    function index()
    {
        $this->load->view('welcome_message');
    }
    
    function email_check($str)
	{
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        
        // set_value('password')には値がまだ?入ってないので$_POST[]を使う
        // trimとかは当然されていないのでここで行う。
	    $pw = $_POST['password'];
	    //var_dump($pw);
		if ($str == 'test')
		{
			$this->form_validation->set_message('email_check', 'フィールド %s に、"test"は使えません');
			return FALSE;
		}
		//else if ($pw == 'test')
		//{
		//	$this->form_validation->set_message('email_check', 'フィールド2 %s に、"test"は使えません');
		//	return FALSE;
		//}
		else
		{
			return TRUE;
		}
	}
    
    public function login()
    {
        // ログイン処理をし、indexページに戻る。
        // URL指定があれば、そのページに移動する。
        $this->load->library('phpsession');
        $this->load->helper(array('form', 'url'));
        $data['title'] = "login";
        $data['headline'] = "";
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        
        //これはOK
        $this->form_validation->set_rules('email', 'メールアドレス', 'required|callback_email_check');
        //↓を有効にすると上が無効になる(最後の1つだけ有効になるようだ)
        //$this->form_validation->set_rules('email', 'メールアドレス', 'trim|valid_email');
        $this->form_validation->set_rules('password', 'パスワード', 'trim|required');
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('users/login');
        }
        else
        {
            $email = set_value('email');
            $password = set_value('password');
            
            // email, passwordをチェックする
            $this->db->where('email', $email);
            $this->db->where('password', sha1($password));
            $this->db->where('status', 2);
            $query = $this->db->get('users', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $this->phpsession->save('userid', $row['userid']);
                $this->phpsession->save('name', $row['name']);
                $this->phpsession->save('email', $row['email']);
                redirect('my/index');
            }
            else
            {
                //↓NG
                $data['error'] = array();
                $data['error'][] = 'メールアドレス、またはパスワードが間違っています。';
                $this->load->vars($data);
                $this->load->view('users/login');
            }
        }
    }
    
    public function logout()
    {
        $this->load->library('phpsession');
        
        $this->phpsession->clear('userid');
        $this->phpsession->clear('name');
        $this->phpsession->clear('email');

        // ログアウト処理をし、indexページに戻る
        redirect('');
    }
    
    /**
     * ユーザ登録
     */
    public function register()
    {
        $this->load->helper(array('form', 'url'));
        $data['title'] = "Register";
        $data['headline'] = "";
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        
        $this->form_validation->set_rules('email', 'メールアドレス', 'required');
        $this->form_validation->set_rules('password', 'パスワード', 'required');
        $this->form_validation->set_rules('name', '氏名', 'required');
        $this->form_validation->set_rules('name_kana', '氏名(ふりがな)', 'required');
        $this->form_validation->set_rules('postcode', '郵便番号', 'required');
        $this->form_validation->set_rules('prefecture', '都道府県', 'required');
        $this->form_validation->set_rules('city', '市区町村', 'required');
        $this->form_validation->set_rules('street', '番地', 'required');
        $this->form_validation->set_rules('phone', '電話番号', 'required');
        
        if ($this->form_validation->run() == FALSE)
        {
            //echo "Form First Or NG";
            $this->load->view('users/register');
        }
        else
        {
            $actkey = uniqid();
            
            $data = array(
                           'email' => set_value('email'),
                           'password' => sha1(set_value('password')),
                           'name' => set_value('name'),
                           'name_kana' => set_value('name_kana'),
                           'postcode' => set_value('postcode'),
                           'prefecture' => set_value('prefecture'),
                           'city' => set_value('city'),
                           'street' => set_value('street'),
                           'phone' => set_value('phone'),
                           'status' => 1,
                           'actkey' => $actkey
                        );
            $this->db->insert('users', $data);
            
            // Eメール送信
            // TODO
            $data['password'] = set_value('password');
            $data['actkey'] = $actkey;
            $this->load->vars($data);
            
            $this->load->view('users/register_accept');
        }
    }
    
    /**
     * ユーザ有効化
     */
    public function activate($actkey)
    {
        $this->db->where('actkey', $actkey);
        $this->db->where('status', 1);
        $query = $this->db->get('users', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $userid = $row['userid'];
            
            $this->db->where('userid', $userid);
            $a = array('status' => 2);
            $this->db->update('users', $a);
            
            $this->load->view('users/activate');
        }
        else
        {
        
        }
    }
    
    /**
     * ユーザ削除
     */
    public function unregister()
    {
        
    }
    
    /**
     * ユーザ編集
     */
    public function edit()
    {
    }
    
    /**
     * return keycode
     */
    private function _keygen()
    {
        $size = 3;
        $key = "";
        $consonne = "bcdfghjklmnpqrstvwxz";
        $voyelle = "aeiouy";
        
        srand((double)microtime()*date("YmdGis"));
        
        for($cnt = 0; $cnt < $size; $cnt++)
        {
            $key .= $consonne[rand(0, 19)].$voyelle[rand(0, 5)];
        }
        return $key;
    }
}

/* End of file users.php */
