<?php
/**
 * Plan Admin
 * @package     ci-hotel
 * @author      Teruki Hosokawa <hosotk@gmail.com>
 * @license     New BSD License
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Plans extends ADMIN_Controller {

    function Plans()
    {
        parent::ADMIN_Controller();
        $this->load->helper(array('form', 'url'));
        $this->load->model('User_model');
        if ($this->User_model->isAdmin() != true)
        {
            redirect('admin/login/index');
        }
    }
    
    /**
     * プラン一覧
     */
    public function index()
    {
        $this->load->helper(array('form', 'url'));
        //$this->db->order_by('ordering ASC');
        $query = $this->db->get('plans');
        $data['plans'] = $query->result_array();
        
        $data['title'] = "Plans";
        $data['headline'] = "";
        $this->load->vars($data);
        
        $this->load->view('admin/plans/index');
    }
    
    /**
     * プランの新規作成
     */
    public function add()
    {
        $this->load->helper(array('form', 'url'));
        $this->load->helper('ck');

        $data['title'] = "add Plan";
        $data['headline'] = "";
        //$data['include'] = 'form_plan';
        $data['summary'] = '';
        $data['description'] = '';
        $this->load->vars($data);
        
        $dbres = $this->db->get('roomtypes');
        $ddmenu = array();
        foreach ($dbres->result_array() as $tablerow) {
            $ddmenu[$tablerow['roomtypeid']] = $tablerow['roomtype_name'];
        }
        $data['options'] = $ddmenu;
        
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        
        // ruleがないときも空でset_rules()しておく。
        // そうでないとset_value()で値が取れなくなる。
        $this->form_validation->set_rules('plan_name', 'プラン名', 'required');
        $this->form_validation->set_rules('summary', '概要', 'required');
        $this->form_validation->set_rules('description', '説明', '');
        $this->form_validation->set_rules('start_date', '開始日付', 'required');
        $this->form_validation->set_rules('end_date', '終了日時', 'required');
        $this->form_validation->set_rules('default_num', 'デフォルト数', 'required');
        $this->form_validation->set_rules('guest_min', '最小人数', 'required');
        $this->form_validation->set_rules('guest_max', '最大人数', 'required');
        $this->form_validation->set_rules('roomtypeid', '部屋タイプ', 'required');
        if ($this->form_validation->run() == FALSE)
        {
            //echo "Form First Or NG";
            $this->load->view('admin/plans/add');
            return;
        }
        else
        {
            $data = array(
                           'plan_name' => set_value('plan_name'),
                           'summary' => $_POST['summary'],
                           'description' => $_POST['description'],
                           'start_date' => set_value('start_date'),
                           'end_date' => set_value('end_date'),
                           'default_num' => set_value('default_num'),
                           'guest_min' => set_value('guest_min'),
                           'guest_max' => set_value('guest_max'),
                           'roomtypeid' => set_value('roomtypeid'),
                           'status' => 1
                        );
            $this->db->insert('plans', $data);
            $planid = $this->db->insert_id();
            $start_date = set_value('start_date');
            $end_date = set_value('end_date');
            $default_num = set_value('default_num');
            $this->update_vacantplans($planid, $start_date, $end_date, $default_num);
            
            redirect('admin/plans');
        }
    }
    
    /**
     * プランの編集
     */
    public function edit($planid)
    {
        $this->load->helper(array('form', 'url'));
        $this->load->helper('ck');
        
        $data['title'] = "edit Plan";
        $data['headline'] = "";
        $data['planid'] = $planid;
        $data['summary'] = '';
        $data['description'] = '';
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        
        // ruleがないときも空でset_rules()しておく。
        // そうでないとset_value()で値が取れなくなる。
        $this->form_validation->set_rules('plan_name', 'プラン名', 'required');
        $this->form_validation->set_rules('summary', '概要', 'required');
        $this->form_validation->set_rules('description', '説明', '');
        $this->form_validation->set_rules('start_date', '開始日付', 'required');
        $this->form_validation->set_rules('end_date', '終了日時', 'required');
        $this->form_validation->set_rules('default_num', 'デフォルト数', 'required');
        $this->form_validation->set_rules('guest_min', '最小人数', 'required');
        $this->form_validation->set_rules('guest_max', '最大人数', 'required');
        $this->form_validation->set_rules('roomtypeid', '部屋タイプ', 'required');
        
        $dbres = $this->db->get('roomtypes');
        $ddmenu = array();
        foreach ($dbres->result_array() as $tablerow) {
          $ddmenu[$tablerow['roomtypeid']] = $tablerow['roomtype_name'];
        }
        
        // フォームの初期値設定
        if (!$this->input->post('submit'))
        {
            $this->db->where('planid', $planid);
            $query = $this->db->get('plans', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $data['plan_name'] = $row['plan_name'];
                $data['summary'] = $row['summary'];
                $data['description'] = $row['description'];
                $data['start_date'] = substr($row['start_date'], 0, 10);
                $data['end_date'] = substr($row['end_date'], 0, 10);
                $data['default_num'] = $row['default_num'];
                $data['guest_min'] = $row['guest_min'];
                $data['guest_max'] = $row['guest_max'];
                $data['roomtypeid'] = $row['roomtypeid'];
                $data['options'] = $ddmenu;
                $this->load->vars($data);
            }
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            //echo "Form First Or NG";
            $this->load->view('admin/plans/edit');
        }
        else
        {
            $data = array(
                           'plan_name' => set_value('plan_name'),
                           'summary' => $_POST['summary'],
                           'description' => $_POST['description'],
                           'start_date' => set_value('start_date'),
                           'end_date' => set_value('end_date'),
                           'default_num' => set_value('default_num'),
                           'guest_min' => set_value('guest_min'),
                           'guest_max' => set_value('guest_max'),
                           'roomtypeid' => set_value('roomtypeid')
                        );
            $this->db->where('planid', $planid);
            $this->db->update('plans', $data);
            
            $start_date = set_value('start_date');
            $end_date = set_value('end_date');
            $default_num = set_value('default_num');
            $this->update_vacantplans($planid, $start_date, $end_date, $default_num);
            
            redirect('admin/plans');
        }
    }
    
    /**
     * プランの削除
     */
    public function delete($planid)
    {
        $this->load->helper('url');
        $this->db->where('planid', $planid);
        $this->db->delete('plans');
        
        $this->db->where('planid', $planid);
        $this->db->delete('vacantplans');
        
        redirect('admin/plans');
    }
    
    /**
     * プランの割り当て人数編集
     */
    public function vacantplans($planid, $cal)
    {
        
    }
    
    /**
     * プランの空き数を更新する
     * 
     * $start_date より前、$end_date より後のレコードを削除する。
     * $start_date ～ $end_date の $planid のレコードがなければ追加する。
     * ある場合は、そのままにしておく。
     * 
     */
    private function update_vacantplans($planid, $start_date, $end_date, $n)
    {
        // $ymd1 より前のデータを削除する
        $this->db->query("DELETE FROM vacantplans WHERE day < '" . $start_date . "'");
        
        // $ymd2 より後のデータを削除する
        $this->db->query("DELETE FROM vacantplans WHERE day > '" . $end_date . "'");
        
        /**
         * $stat_date ～ $end_date の期間の vacantplans レコードがなければ追加する。
         * レコードがある場合は、そのままにしておく。
         */
        //http://oshiete.goo.ne.jp/qa/1463100.html
        // UNIXタイムスタンプ取得
        list($sy, $sm, $sd) = explode('-', $start_date);
        list($ey, $em, $ed) = explode('-', $end_date);
        $su = mktime(0, 0, 0, $sm, $sd, $sy);
        $eu = mktime(0, 0, 0, $em, $ed, $ey);
        // 1日の秒数
        $sec = 60 * 60 * 24;    // 60秒 × 60分 × 24時間
        // 日付取得
        $key = 0;
        for ($i = $su; $i <= $eu; $i += $sec)
        {
            $d = date('Y-m-d', $i);
            
            $this->db->where('day', $d);
            $this->db->where('planid', $planid);
            $query = $this->db->get('vacantplans', 1);
            if ($query->num_rows() <= 0)
            {
                $data = array(
                               'day' => $d,
                               'planid' => $planid,
                               'num' => $n
                            );
                $this->db->insert('vacantplans', $data);
            }
        }
    }
}

/* End of file plans.php */
