<?php
/**
 * Roomtypes Admin
 * @package     hotel reservation system
 * @author      Teruki Hosokawa <hosotk@gmail.com>
 * @licence     New BSD Licence
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Roomtypes extends ADMIN_Controller {

    function Roomtypes()
    {
        parent::ADMIN_Controller();
        $this->load->helper(array('form', 'url'));
        $this->load->model('User_model');
        if ($this->User_model->isAdmin() != true)
        {
            redirect('admin/login/index');
        }
    }
    
    /**
     * 部屋タイプ一覧
     */
    public function index()
    {
        $this->load->helper(array('form', 'url'));
        //$this->db->order_by('ordering ASC');
        $query = $this->db->get('roomtypes');
        $data['roomtypes'] = $query->result_array();
        
        $data['title'] = "Roomtypes";
        $data['headline'] = "";
        $this->load->vars($data);
        
        $this->load->view('admin/roomtypes/index');
    }
    
    /**
     * 部屋タイプの新規作成
     */
    public function add()
    {
        $this->load->helper(array('form', 'url'));
        $this->load->helper('ck');
        
        $data['title'] = "add Roomtypes";
        $data['headline'] = "";
        //$data['include'] = 'form_roomtype';
        $data['summary'] = '';
        $data['description'] = '';
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        
        // ruleがないときも空でset_rules()しておく。
        // そうでないとset_value()で値が取れなくなる。
        $this->form_validation->set_rules('roomtype_name', '部屋タイプ名', 'required');
        $this->form_validation->set_rules('summary', '概要', 'required');
        $this->form_validation->set_rules('description', '説明', '');
        $this->form_validation->set_rules('start_date', '開始日付', 'required');
        $this->form_validation->set_rules('end_date', '終了日時', 'required');
        $this->form_validation->set_rules('default_num', 'デフォルト数', 'required');
        $this->form_validation->set_rules('guest_min', '最小人数', 'required');
        $this->form_validation->set_rules('guest_max', '最大人数', 'required');
        
        if ($this->form_validation->run() == FALSE)
        {
            //echo "Form First Or NG";
            $this->load->view('admin/roomtypes/add');
        }
        else
        {
            $data = array(
                           'roomtype_name' => set_value('roomtype_name'),
                           'summary' => $_POST['summary'],
                           'description' => $_POST['description'],
                           'start_date' => set_value('start_date'),
                           'end_date' => set_value('end_date'),
                           'default_num' => set_value('default_num'),
                           'guest_min' => set_value('guest_min'),
                           'guest_max' => set_value('guest_max'),
                           'status' => 1
                        );
            $this->db->insert('roomtypes', $data);
            $roomtypeid = $this->db->insert_id();
            $start_date = set_value('start_date');
            $end_date = set_value('end_date');
            $default_num = set_value('default_num');
            $this->update_vacantrooms($roomtypeid, $start_date, $end_date, $default_num);
            
            redirect('admin/roomtypes');
        }
    }
    
    /**
     * 部屋タイプの編集
     */
    public function edit($roomtypeid)
    {
        $this->load->helper(array('form', 'url'));
        $this->load->helper('ck');
        
        $data['title'] = "edit Roomtype";
        $data['headline'] = "";
        $data['roomtypeid'] = $roomtypeid;
        $data['summary'] = '';
        $data['description'] = '';
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        
        // ruleがないときも空でset_rules()しておく。
        // そうでないとset_value()で値が取れなくなる。
        $this->form_validation->set_rules('roomtype_name', '部屋タイプ名', 'required');
        $this->form_validation->set_rules('summary', '概要', 'required');
        $this->form_validation->set_rules('description', '説明', '');
        $this->form_validation->set_rules('start_date', '開始日付', 'required');
        $this->form_validation->set_rules('end_date', '終了日時', 'required');
        $this->form_validation->set_rules('default_num', 'デフォルト数', 'required');
        $this->form_validation->set_rules('guest_min', '最小人数', 'required');
        $this->form_validation->set_rules('guest_max', '最大人数', 'required');
        
        // フォームの初期値設定
        if (!$this->input->post('submit'))
        {
            $this->db->where('roomtypeid', $roomtypeid);
            $query = $this->db->get('roomtypes', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $data['roomtype_name'] = $row['roomtype_name'];
                $data['summary'] = $row['summary'];
                $data['description'] = $row['description'];
                $data['start_date'] = substr($row['start_date'], 0, 10);
                $data['end_date'] = substr($row['end_date'], 0, 10);
                $data['default_num'] = $row['default_num'];
                $data['guest_min'] = $row['guest_min'];
                $data['guest_max'] = $row['guest_max'];
                $this->load->vars($data);
            }
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            //echo "Form First Or NG";
            $this->load->view('admin/roomtypes/edit');
        }
        else
        {
            $data = array(
                           'roomtype_name' => set_value('roomtype_name'),
                           'summary' => $_POST['summary'],
                           'description' => $_POST['description'],
                           'start_date' => set_value('start_date'),
                           'end_date' => set_value('end_date'),
                           'default_num' => set_value('default_num'),
                           'guest_min' => set_value('guest_min'),
                           'guest_max' => set_value('guest_max'),
                           'status' => 1
                           //'modified' => date("Y-m-d H：i：s")
                        );
            /**
             * 2010-10-11
             * htmlを含むset_value()を代入するとhtmlspecialchars()
             * を通した値に勝手に変換される。(原因は不明???)
             * そのため、ckeditorを使う項目は$_POST[]を使う。
             */
            //log_message('info', '_POST=' . $_POST['summary']);
            //log_message('info', 'set_value=' . set_value('summary'));
            //log_message('info', 'data=' . $data['summary']);
            
            $this->db->where('roomtypeid', $roomtypeid);
            $this->db->update('roomtypes', $data);
            
            $start_date = set_value('start_date');
            $end_date = set_value('end_date');
            $default_num = set_value('default_num');
            $this->update_vacantrooms($roomtypeid, $start_date, $end_date, $default_num);
            
            redirect('admin/roomtypes');
        }
    }
    
    /**
     * 部屋タイプの削除
     */
    public function delete($roomtypeid)
    {
        $this->load->helper('url');
        $this->db->where('roomtypeid', $roomtypeid);
        $this->db->delete('roomtypes');
        
        $this->db->where('roomtypeid', $roomtypeid);
        $this->db->delete('vacantroomtypes');
        
        redirect('admin/roomtypes');
    }
    
    /**
     * 部屋タイプの空き数を更新する
     * 
     * $start_date より前、$end_date より後のレコードを削除する。
     * $start_date ～ $end_date の $planid のレコードがなければ追加する。
     * ある場合は、そのままにしておく。
     * 
     */
    private function update_vacantrooms($roomtypeid, $start_date, $end_date, $n)
    {
        // $ymd1 より前のデータを削除する
        $this->db->query("DELETE FROM vacantrooms WHERE day < '" . $start_date . "'");
        
        // $ymd2 より後のデータを削除する
        $this->db->query("DELETE FROM vacantrooms WHERE day > '" . $end_date . "'");
        
        /**
         * $stat_date ～ $end_date の期間の vacantrooms レコードがなければ追加する。
         * レコードがある場合は、そのままにしておく。
         */
        //http://oshiete.goo.ne.jp/qa/1463100.html
        // UNIXタイムスタンプ取得
        list($sy, $sm, $sd) = explode('-', $start_date);
        list($ey, $em, $ed) = explode('-', $end_date);
        $su = mktime(0, 0, 0, $sm, $sd, $sy);
        $eu = mktime(0, 0, 0, $em, $ed, $ey);
        // 1日の秒数
        $sec = 60 * 60 * 24;    // 60秒 × 60分 × 24時間
        // 日付取得
        $key = 0;
        for ($i = $su; $i <= $eu; $i += $sec)
        {
            $d = date('Y-m-d', $i);
            
            $this->db->where('day', $d);
            $this->db->where('roomtypeid', $roomtypeid);
            $query = $this->db->get('vacantrooms', 1);
            if ($query->num_rows() <= 0)
            {
                $data = array(
                               'day' => $d,
                               'roomtypeid' => $roomtypeid,
                               'num' => $n
                            );
                $this->db->insert('vacantrooms', $data);
                //var_dump($data);
            }
        }
    }
    
    /**
     * 部屋空き数の調整
     *
     */
    // TODO
}

/* End of file roomtypes.php */
