<?php
/**
 * Admin Users
 *
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Users extends ADMIN_Controller {

    function Users()
    {
        parent::ADMIN_Controller();
        $this->load->helper(array('form', 'url'));
        $this->load->model('User_model');
        if ($this->User_model->isAdmin() != true)
        {
            redirect('admin/login/index');
        }
    }
    
    public function index()
    {
        /**
         * ユーザリストを表示する
         */
        $this->load->helper(array('form', 'url'));
        //$this->db->order_by('ordering ASC');
        $this->db->where('status >', 0);
        $query = $this->db->get('users');
        $data['users'] = $query->result_array();
        $this->load->vars($data);
        
        $this->load->view('admin/users/index');
    }
    
    public function logout()
    {
        $this->load->helper(array('form', 'url'));
        $this->load->library('phpsession');
        
        $this->phpsession->clear('userid');
        $this->phpsession->clear('name');
        $this->phpsession->clear('email');
        $this->phpsession->clear('usertype');
        $this->phpsession->clear('hotelid');
        
        redirect('admin');
    }
    
    /**
     * 管理者によるユーザ登録
     */
    public function add()
    {
        $this->load->helper(array('form', 'url'));
        
        $this->load->library('form_validation');
        
        $this->form_validation->set_rules('name', '氏名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('name_kana', '氏名カナ', 'required|trim|xss_clean');
        $this->form_validation->set_rules('email', 'メールアドレス', 'required|valid_email|trim|xss_clean');
        $this->form_validation->set_rules('password', 'パスワード', 'required|trim|xss_clean');
        $this->form_validation->set_rules('usertype', 'ユーザ種別', 'required|trim|xss_clean');
        $this->form_validation->set_rules('postcode', '郵便番号', 'required|trim|xss_clean');
        $this->form_validation->set_rules('prefecture', '都道府県', 'required|trim|xss_clean');
        $this->form_validation->set_rules('city', '市区町村', 'required|trim|xss_clean');
        $this->form_validation->set_rules('street', '番地', 'required|trim|xss_clean');
        $this->form_validation->set_rules('phone', '電話番号', 'required|trim|xss_clean');
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('admin/users/add');
            return;
        }
        else
        {
            // 同じemailがすでに登録済みならばエラー
            // TODO
            
            $data = array(
                'name' => set_value('name'),
                'name_kana' => set_value('name_kana'),
                'email' => set_value('email'),
                'usertype' => set_value('usertype'),
                'postcode' => set_value('postcode'),
                'prefecture' => set_value('prefecture'),
                'city' => set_value('city'),
                'street' => set_value('street'),
                'phone' => set_value('phone'),
                'password' => sha1(set_value('password')),
                'status' => 2);
            $this->db->insert('users', $data);
            redirect('admin/users/index');
        }
        
        $this->load->view('admin/users/add');
    }
    
    /**
     *
     */
    public function edit($userid)
    {
        $this->load->helper(array('form', 'url'));
        
        $data['userid'] = $userid;
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        
        $this->form_validation->set_rules('name', '氏名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('name_kana', '氏名カナ', 'required|trim|xss_clean');
        $this->form_validation->set_rules('email', 'メールアドレス', 'required|valid_email|trim|xss_clean');
        $this->form_validation->set_rules('password', 'パスワード', 'trim|xss_clean');
        $this->form_validation->set_rules('usertype', 'ユーザ種別', 'required|trim|xss_clean');
        $this->form_validation->set_rules('postcode', '郵便番号', 'required|trim|xss_clean');
        $this->form_validation->set_rules('prefecture', '都道府県', 'required|trim|xss_clean');
        $this->form_validation->set_rules('city', '市区町村', 'required|trim|xss_clean');
        $this->form_validation->set_rules('street', '番地', 'required|trim|xss_clean');
        $this->form_validation->set_rules('phone', '電話番号', 'required|trim|xss_clean');
        
        if (!$this->input->post('submit'))
        {
            $this->db->where('userid', $userid);
            $query = $this->db->get('users', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $data['name'] = $row['name'];
                $data['name_kana'] = $row['name_kana'];
                $data['email'] = $row['email'];
                $data['password'] = '';
                $data['usertype'] = $row['usertype'];
                $data['postcode'] = $row['postcode'];
                $data['prefecture'] = $row['prefecture'];
                $data['city'] = $row['city'];
                $data['street'] = $row['street'];
                $data['phone'] = $row['phone'];
                $this->load->vars($data);
            }
        }
        
        if ($this->form_validation->run() == FALSE)
        {
        }
        else
        {
            // 同じemailがすでに登録済みならばエラー
            // TODO
            
            if (set_value('password') != '')
            {
                $data = array(
                    'name' => set_value('name'),
                    'name_kana' => set_value('name_kana'),
                    'email' => set_value('email'),
                    'usertype' => set_value('usertype'),
                    'postcode' => set_value('postcode'),
                    'prefecture' => set_value('prefecture'),
                    'city' => set_value('city'),
                    'street' => set_value('street'),
                    'phone' => set_value('phone'),
                    'password' => sha1(set_value('password')));
            }
            else
            {
                // パスワード入力がないときはパスワードを変更しない。
                $data = array(
                    'name' => set_value('name'),
                    'name_kana' => set_value('name_kana'),
                    'email' => set_value('email'),
                    'usertype' => set_value('usertype'),
                    'postcode' => set_value('postcode'),
                    'prefecture' => set_value('prefecture'),
                    'city' => set_value('city'),
                    'street' => set_value('street'),
                    'phone' => set_value('phone'));
            }
            $this->db->where('userid', $userid);
            $this->db->update('users', $data);
        }
        
        $this->load->view('admin/users/edit');
    }
    
    /**
     * ユーザの削除
     */
    public function delete($userid)
    {
        $this->load->helper(array('form', 'url'));
        
        // $useridが管理ユーザの場合、
        // 他に管理ユーザがいることをチェックする。
        // TODO
        
        $data = array('status' => 0);
        $this->db->where('userid', $userid);
        $this->db->update('users', $data);
        
        redirect('admin/users/index');
    }
}
