<?php
/**
 * Installer
 * @package ci-hotel
 *
 */
class Install extends Controller {

    public function __construct()
    {
        parent::Controller();
    }
    
    public function index()
    {
        $this->load->helper(array('form', 'url'));
        
        if ($this->db->table_exists('system') == false)
        {
            $this->load->view('install/index');
            return;
        }
    }
    
    private function is_installed()
    {
        
        
        return false;
    }
    
    public function create_schema()
    {
        $this->load->helper(array('form', 'url'));
        
        $q = array();
        $q[] = 'CREATE TABLE system ('
             . 'name VARCHAR(255) NOT NULL UNIQUE,'
             . 'value VARCHAR(255))';
        $q[] = 'CREATE TABLE hotel ('
             . 'hotelid INT NOT NULL,'
             . 'hotel_name VARCHAR(255) NOT NULL,'
             . 'postcode VARCHAR(10),'
             . 'prefecture VARCHAR(255),'
             . 'city VARCHAR(255),'
             . 'street VARCHAR(255),'
             . 'phone VARCHAR(16),'
             . 'email VARCHAR(255),'
             . 'url VARCHAR(255),'
             . 'res_prev_days INT NOT NULL,'
             . 'res_term INT NOT NULL,'
             . 'res1_mail TEXT,'
             . 'res2_mail TEXT,'
             . 'res_cancel_mail TEXT,'
             . 'cancel_porycy TEXT,'
             . 'topics TEXT,'
             . 'cin_hour VARCHAR(32),'
             . 'cout_hour VARCHAR(32),'
             . 'PRIMARY KEY(hotelid))';
        $q[] = 'CREATE TABLE plans ('
             . 'planid INT NOT NULL AUTO_INCREMENT,'
             . 'plan_name VARCHAR(255) NOT NULL,'
             . 'roomtypeid INT NOT NULL,'
             . 'status INT NOT NULL,'
             . 'summary TEXT,'
             . 'description TEXT,'
             . 'created DATETIME,'
             . 'modified DATETIME,'
             . 'start_date DATE,'
             . 'end_date DATE,'
             . 'guest_min INT NOT NULL,'
             . 'guest_max INT NOT NULL,'
             . 'default_num INT NOT NULL,'
             . 'basic_count  TINYINT(1) NOT NULL DEFAULT 1,'
             . 'child1_count TINYINT(1) DEFAULT 1,'
             . 'child2_count TINYINT(1) DEFAULT 0,'
             . 'child3_count TINYINT(1) DEFAULT 0,'
             . 'child4_count TINYINT(1) DEFAULT 0,'
             . 'PRIMARY KEY(planid))';
        $q[] = 'CREATE TABLE roomtypes ('
             . 'roomtypeid INT NOT NULL AUTO_INCREMENT,'
             . 'roomtype_name VARCHAR(255),'
             . 'status INT NOT NULL,'
             . 'summary TEXT,'
             . 'description TEXT,'
             . 'created DATETIME,'
             . 'modified DATETIME,'
             . 'start_date DATE,'
             . 'end_date DATE,'
             . 'guest_min INT NOT NULL,'
             . 'guest_max INT NOT NULL,'
             . 'default_num INT NOT NULL,'
             . 'PRIMARY KEY(roomtypeid))';
        $q[] = 'CREATE TABLE daytype ('
             . 'day DATE NOT NULL UNIQUE,'
             . 'value VARCHAR(1))';
        $q[] = 'CREATE TABLE planprice ('
             . 'planid INT NOT NULL,'
             . 'a_basic_price VARCHAR(255),'
             . 'b_basic_price VARCHAR(255),'
             . 'c_basic_price VARCHAR(255),'
             . 'd_basic_price VARCHAR(255),'
             . 'a_child1_price VARCHAR(255),'
             . 'b_child1_price VARCHAR(255),'
             . 'c_child1_price VARCHAR(255),'
             . 'd_child1_price VARCHAR(255),'
             . 'a_child2_price VARCHAR(255),'
             . 'b_child2_price VARCHAR(255),'
             . 'c_child2_price VARCHAR(255),'
             . 'd_child2_price VARCHAR(255),'
             . 'a_child3_price VARCHAR(255),'
             . 'b_child3_price VARCHAR(255),'
             . 'c_child3_price VARCHAR(255),'
             . 'd_child3_price VARCHAR(255),'
             . 'a_child4_price VARCHAR(255),'
             . 'b_child4_price VARCHAR(255),'
             . 'c_child4_price VARCHAR(255),'
             . 'd_child4_price VARCHAR(255),'
             . 'created DATETIME,'
             . 'modified DATETIME,'
             . 'status INT)';
        /**
         * rescode:予約コード
         * 未登録ユーザの予約キャンセルは
         * 電話で予約コードと氏名を言ってもらい、管理者が手続きをする。
         */
        $q[] = 'CREATE TABLE reservation ('
             . 'resid INT NOT NULL AUTO_INCREMENT,'
             . 'rescode VARCHAR(32),'
             . 'userid INT NOT NULL,'
             . 'planid INT NOT NULL,'
             . 'roomtypeid INT NOT NULL,'
             . 'basic_num INT NOT NULL,'
             . 'child1_num INT NOT NULL,'
             . 'child2_num INT NOT NULL,'
             . 'child3_num INT NOT NULL,'
             . 'child4_num INT NOT NULL,'
             . 'room_num INT NOT NULL,'
             . 'plan_num INT NOT NULL,'
             . 'cin DATE NOT NULL,'
             . 'cinhour TIME,'
             . 'cout DATE NOT NULL,'
             . 'created DATETIME,'
             . 'total_price INT,'
             . 'status INT,'
             . 'memo VARCHAR(255),'
             . 'PRIMARY KEY(resid))';
        // 予約者情報
        $q[] = 'CREATE TABLE resuser ('
             . 'resid INT NOT NULL,'
             . 'userid INT NOT NULL,'       // 0:未登録ユーザ,それ以外:登録ユーザ
             . 'name VARCHAR(255),'
             . 'name_kana VARCHAR(255),'
             . 'birth DATE,'
             . 'gender TINYINT(1),'
             . 'postcode VARCHAR(10),'
             . 'prefecture VARCHAR(255),'
             . 'city VARCHAR(255),'
             . 'street VARCHAR(255),'
             . 'email VARCHAR(255),'
             . 'phone VARCHAR(16),'
             . 'email2 VARCHAR(255),'
             . 'phone2 VARCHAR(16),'
             . 'company VARCHAR(255),'
             . 'division VARCHAR(255),'
             . 'fax VARCHAR(16))';
        $q[] = 'CREATE TABLE users ('
             . 'userid INT NOT NULL AUTO_INCREMENT,'
             . 'usertype VARCHAR(16),'
             . 'hotelid INT,'
             . 'password VARCHAR(255),'
             . 'name VARCHAR(255),'
             . 'name_kana VARCHAR(255),'
             . 'birth DATE,'
             . 'gender TINYINT(1),'
             . 'postcode VARCHAR(10),'
             . 'prefecture VARCHAR(255),'
             . 'city VARCHAR(255),'
             . 'street VARCHAR(255),'
             . 'email VARCHAR(255),'
             . 'phone VARCHAR(16),'
             . 'email2 VARCHAR(255),'
             . 'phone2 VARCHAR(16),'
             . 'company VARCHAR(255),'
             . 'division VARCHAR(255),'
             . 'fax VARCHAR(16),'
             . 'status INT,'
             . 'actkey VARCHAR(128),'
             . 'PRIMARY KEY(userid))';
        $q[] = 'CREATE TABLE vacantrooms ('
             . 'day DATE NOT NULL,'
             . 'roomtypeid INT NOT NULL,'
             . 'num INT NOT NULL)';
        $q[] = 'CREATE TABLE vacantplans ('
             . 'day DATE NOT NULL,'
             . 'planid INT NOT NULL,'
             . 'num INT NOT NULL)';
             
        // data
        $q[] = "INSERT INTO users ("
             . "userid, usertype, hotelid, email, password, status) VALUES("
             . "1, 'admin', 1, 'admin', '" . sha1("admin") . "', 2)";
        $q[] = "INSERT INTO hotel ("
             . "hotelid, hotel_name, res_prev_days, res_term) VALUES("
             . "1, 'ci-hotel', 0, 6)";
        foreach ($q as $v)
        {
            $this->db->query($v);
        }
        $this->load->view('install/create_schema');
    }
    
}

/* End of file install.php */
