<?php
class My extends MY_Controller {
    
    function My()
    {
        parent::MY_Controller();
        $this->load->model('Res_model');
        $this->load->model('Hotel_model');
    }
    
    /**
     * 予約リストを表示する
     */
    function index()
    {
        $this->load->library('phpsession');
        $this->load->helper(array('form', 'url'));
        $data['title'] = "login";
        $data['headline'] = "";
        $this->load->vars($data);
        
        // ログインチェック
        $userid = $this->phpsession->get('userid');
        if ($userid <= 0)
        {
            die();
        }
        
        // ユーザの予約リストを得る
        $this->db->where('userid', $userid);
        $this->db->where('status >', 0);
        $this->db->order_by('created', 'desc');
        $query = $this->db->get('reservation');
        
        $data['ress'] = $query->result_array();
        $data['title'] = "User Res";
        $data['headline'] = "";
        $this->load->vars($data);
        
        $this->load->view('my/index');
    }
    
    /**
     * 予約詳細
     */
    public function resdetail($resid)
    {
        // 予約詳細をみる
        $this->db->where('resid', $resid);
        $query = $this->db->get('reservation');
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
        }
        else
        {
            die();
        }
        $this->load->vars($data);
        
        $userid = $this->phpsession->get('userid');
        if ($userid <= 0)
        {
            die();
        }
        if ($data["userid"] != $userid)
        {
            die();
        }
        
        $this->load->view('my/resdetail');
    }
    
    /**
     * 予約キャンセル
     */
    public function rescancel($resid)
    {
        $userid = $this->phpsession->get('userid');
        if ($userid <= 0)
        {
            die();
        }
        
        // 予約詳細をみる
        $this->db->where('resid', $resid);
        $query = $this->db->get('reservation');
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
            if ($data['userid'] == $userid)
            {
                $this->Res_model->cancel($resid, 1, $this->Hotel_model);
            }
        }
        else
        {
            die();
        }
        redirect('res/estimate');
    }
}
