<?php
/**
 *  予約
 */
class Res extends MY_Controller {
    
    // 予約エラーコード
    const ERR_ROOM_GUEST_MIN = -1;  // 部屋あたりの人数が下限より小
    const ERR_ROOM_GUEST_MAX = -2;  // 部屋あたりの人数が上限より大
    const ERR_PLAN_GUEST_MIN = -3;  // 
    const ERR_PLAN_GUEST_MAX = -4;  // 
    const ERR_VACANT_PLAN = -5;
    const ERR_VACANT_ROOM = -6;
    
    function Res()
    {
        parent::MY_Controller();
        $this->load->model('Common_model');
        $this->load->model('Res_model');
        $this->load->model('Hotel_model');
    }
    
    /**
     * 条件入力
     * 
     * @param $d チェックイン日 YYYYMMDD
     */
    function index($planid, $d)
    {
        $error = array();
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->load->library('phpsession');
        
        $data['planid'] = $planid;
        $data['d'] = $d;
        $this->load->vars($data);
        
        $cin = substr($d, 0, 4) . '-'
             . substr($d, 4, 2) . '-'
             . substr($d, 6, 2);
        
        $this->form_validation->set_rules('cout', 'チェックアウト日', 'required|trim|xss_clean');
        $this->form_validation->set_rules('room_num', '部屋数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('basic_num', '大人人数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('child1_num', '子供1人数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('child2_num', '子供2人数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('child3_num', '子供3人数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('child4_num', '子供4人数', 'required|integer|trim|xss_clean');
        
        $this->db->where('planid', $planid);
        $query = $this->db->get('plans', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
        }
        $data['planid'] = $planid;
        $this->load->vars($data);
        
        if (!$this->input->post('mysubmit'))
        {
            $data['child1_num'] = 0;
            $data['child2_num'] = 0;
            $data['child3_num'] = 0;
            $data['child4_num'] = 0;
            $this->load->vars($data);
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('res/index');
        }
        else
        {
            $cout = set_value('cout');
            $room_num = set_value('room_num');
            $basic_num = set_value('basic_num');
            $child1_num = set_value('child1_num');
            $child2_num = set_value('child2_num');
            $child3_num = set_value('child3_num');
            $child4_num = set_value('child4_num');
            
            // 日付のチェック
            // TODO
            // 1 cinが今日以降であること
            // 2 coutがcinより1日以上後であること
            if ($this->Common_model->checkDate($cin) == false)
            {
                $data['error'] = array();
                $data['error'][] = 'チェックインの日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('res/index');
                return;
            }
            if ($this->Common_model->checkDate($cout) == false)
            {
                $data['error'] = array();
                $data['error'][] = 'チェックアウトの日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('res/index');
                return;
            }
            
            // YYYY-MM-DD -> YYYYMMDD
            $cin2 = $d;
            $cout2 = substr($cout, 0, 4) . substr($cout, 5, 2) . substr($cout, 8, 2);
            $today2 = date("Ymd");
            
            if ($today2 > $cin2)
            {
                $data['error'] = array();
                $data['error'][] = 'チェックインの日付は今日以降を指定します。';
                $this->load->vars($data);
                $this->load->view('res/index');
                return;
            }
            if ($cin2 >= $cout2)
            {
                $data['error'] = array();
                $data['error'][] = 'チェックアウトの日付はチェックインの翌日以降を指定します。';
                $this->load->vars($data);
                $this->load->view('res/index');
                return;
            }
            
            // 入力値をセッションに保存する。
            $this->phpsession->save('cin', $cin);
            $this->phpsession->save('cout', $cout);
            $this->phpsession->save('planid', $planid);
            $this->phpsession->save('room_num', $room_num);
            $this->phpsession->save('basic_num', $basic_num);
            $this->phpsession->save('child1_num', $child1_num);
            $this->phpsession->save('child2_num', $child2_num);
            $this->phpsession->save('child3_num', $child3_num);
            $this->phpsession->save('child4_num', $child4_num);
            
            $ret = $this->Res_model->checkRes();
            if ($ret >= 0)
            {
                redirect('res/estimate');
            }
            else
            {
                $s = $this->Res_model->getErrorString($ret);
                $data['error'] = array();
                $data['error'][] = $s;
                $this->load->vars($data);
                $this->load->view('res/index');
            }
        }
    }
    
    /**
     * 見積もり,ユーザ情報入力方法の選択
     * - ログインする
     * - 未登録で予約する
     * - ユーザ登録する
     */
    function estimate()
    {
        $this->load->library('phpsession');
        $this->load->helper(array('form', 'url'));
        
        $planid = $this->phpsession->get('planid');
        $this->db->where('planid', $planid);
        $query = $this->db->get('plans', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
        }
        $data['planid'] = $planid;
        $this->load->vars($data);
        
        // ログイン済みであれば、userinp()にリダイレクトする
        $userid = $this->phpsession->get('userid');
        $usertype = $this->phpsession->get('usertype');
        if ($userid > 0 && $usertype != 'admin')
        {
            redirect('res/userinp');
        }
        
        // そうでなければ見積画面を表示する
        $this->load->view('res/estimate');
    }
    
    function login()
    {
        $this->load->library('phpsession');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        
        $this->form_validation->set_rules('email', 'メールアドレス', 'required||trim|xss_clean');
        $this->form_validation->set_rules('password', 'パスワード', 'required|trim|xss_clean');
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('res/login');
            return;
        }
        else
        {
            $email = set_value('email');
            $password = set_value('password');
            
            // email, passwordをチェックする
            $this->db->where('email', $email);
            $this->db->where('password', sha1($password));
            $this->db->where('status', 2);
            $query = $this->db->get('users', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $this->phpsession->save('userid', $row['userid']);
                $this->phpsession->save('name', $row['name']);
                $this->phpsession->save('email', $row['email']);
                redirect('res/userinp');
            }
            else
            {
                echo $email;
                echo sha1($password);
                
                $data['error'] = "メールアドレス、またはパスワードが間違っています。";
                $this->load->vars($data);
                $this->load->view('users/login');
                return;
            }
        }
    }
    
    /**
     * ユーザ情報の入力
     */
    function userinp()
    {
        $this->load->helper(array('form', 'url'));
        $this->load->library('phpsession');
        $data['title'] = "userinp";
        $data['headline'] = "";
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        
        $this->form_validation->set_rules('name', '氏名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('name_kana', '氏名カナ', 'required|trim|xss_clean');
        $this->form_validation->set_rules('email', 'メールアドレス', 'required|valid_email|trim|xss_clean');
        $this->form_validation->set_rules('postcode', '郵便番号', 'required|trim|xss_clean');
        $this->form_validation->set_rules('prefecture', '都道府県', 'required|trim|xss_clean');
        $this->form_validation->set_rules('city', '市区町村', 'required|trim|xss_clean');
        $this->form_validation->set_rules('street', '番地', 'required|trim|xss_clean');
        $this->form_validation->set_rules('phone', '電話番号', 'required|trim|xss_clean');
        
        // フォームの初期値設定
        // ログインしていくときは、ユーザ情報を初期値に設定する。
        if (!$this->input->post('submit'))
        {
            $userid = $this->phpsession->get('userid');
            if ($userid > 0)
            {
                $this->db->where('userid', $userid);
                $query = $this->db->get('users', 1);
                if ($query->num_rows() > 0)
                {
                    $row = $query->row_array();
                    $data['name'] = $row['name'];
                    $data['name_kana'] = $row['name_kana'];
                    $data['email'] = $row['email'];
                    $data['postcode'] = $row['postcode'];
                    $data['prefecture'] = $row['prefecture'];
                    $data['city'] = $row['city'];
                    $data['street'] = $row['street'];
                    $data['phone'] = $row['phone'];
                    $this->load->vars($data);
                }
            }
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('res/userinp');
        }
        else
        {
            // ユーザ情報をセッションに保存する
            $this->phpsession->save('name', set_value('name'));
            $this->phpsession->save('name_kana', set_value('name_kana'));
            $this->phpsession->save('email', set_value('email'));
            $this->phpsession->save('postcode', set_value('postcode'));
            $this->phpsession->save('prefecture', set_value('prefecture'));
            $this->phpsession->save('city', set_value('city'));
            $this->phpsession->save('street', set_value('street'));
            $this->phpsession->save('phone', set_value('phone'));
            redirect('res/confirm');
        }
    }
    
    /**
     * 確認
     */
    function confirm()
    {
        $this->load->helper(array('form', 'url'));
        $this->load->library('phpsession');
        
        $planid = $this->phpsession->get('planid');
        $this->db->where('planid', $planid);
        $query = $this->db->get('plans', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
        }
        $data['planid'] = $planid;
        $this->load->vars($data);
        
        if ($this->input->post('submit'))
        {
            // 
            log_message('info', 'Res_model->doRes() >>');
            
            $resid = $this->Res_model->doRes($this->Hotel_model);
            if ($resid < 0)
            {
                log_message('info', 'Res_model->doRes() NG <<');
                // 予約失敗
                redirect('res/failure/' . $resid);
            }
            log_message('info', 'Res_model->doRes() OK <<');
            
            redirect('res/accept/');
        }
        
        $this->load->view('res/confirm');
    }
    
    /**
     * 予約完了画面
     */
    function accept()
    {
        $this->load->helper(array('form', 'url'));
        $this->load->library('phpsession');
        
        $this->load->view('res/accept');
    }
    
    /**
     * 予約失敗画面
     * # 予約処理中に他の予約が完了したときに発生する。
     */
    function failure($errorcode)
    {
        $this->load->helper(array('form', 'url'));
        $this->load->library('phpsession');
        
        switch ($errorcode)
        {
        }
        
        $this->load->view('res/failure');
    }
}

/* End of file res.php */
