<?php
/**
 * 予約モデル
 */
// Qdmailのエラー(E_DEPRECATED)がでるので...
error_reporting(E_ALL & ~E_DEPRECATED);

include(dirname(__FILE__) . "/../libraries/qdmail.php");

class Res_model extends Model {
    
    var $lockdir = "./private/ci-hotel.lock";     // ロック用ディレクトリ
    
    // 予約エラーコード
    const ERR_ROOM_GUEST_MIN = -1;  // 部屋あたりの人数が下限より小
    const ERR_ROOM_GUEST_MAX = -2;  // 部屋あたりの人数が上限より大
    const ERR_PLAN_GUEST_MIN = -3;  // 
    const ERR_PLAN_GUEST_MAX = -4;  // 
    const ERR_VACANT_PLAN = -5;
    const ERR_VACANT_ROOM = -6;
    const ERR_PARAM = -10;          // パラメータエラー
    
    /**
     * 予約エラーコードから文字列を返す
     */
    function getErrorString($i)
    {
        $ret = '';
        switch ($i)
        {
            case Res_model::ERR_ROOM_GUEST_MIN:
                $ret = "部屋あたりの人数が部屋タイプの下限より少ない。";
                break;
            case Res_model::ERR_ROOM_GUEST_MAX:
                $ret = "部屋あたりの人数が部屋タイプの上限より多い。";
                break;
            case Res_model::ERR_PLAN_GUEST_MIN:
                $ret = "人数がプランの最小人数より少ない。";
                break;
            case Res_model::ERR_PLAN_GUEST_MAX:
                $ret = "人数がプランの最大人数より多い。";
                break;
            case Res_model::ERR_VACANT_PLAN:
                $ret = "プランの空き数がありません。";
                break;
            case Res_model::ERR_VACNT_ROOM:
                $ret = "部屋の空き数がありません。";
                break;
            case Res_model::ERR_PARAM:
                $ret = "パラメータエラー";
                break;
        }
        return $ret;
    }
    
    function Common_model()
    {
        parent::Model();
    }
    
    public function lock()
    {
        $i = 0;
        while (!mkdir($this->lockdir))
        {
            usleep(100000);             // 0.1秒待つ
            if ($i++ > 100)
            {
                break;
            }
        }
        if ($i > 100)
        {
            log_message('error', 'lock ERROR');
        }
        else
        {
            log_message('info', 'locked');
        }
    }
    
    public function unlock()
    {
        rmdir($this->lockdir);
        log_message('info', 'unlocked');
    }
    
    
    
    
    /**
     * 予約内容をチェックする
     * #チェックのみで、DBの更新はしない
     * 
     * セッションの予約データを参照する。
     * @return 0:正常,負数:エラー
     */
    public function checkRes()
    {
        $this->load->library('phpsession');
        
        $planid = $this->phpsession->get('planid');
        $cin = $this->phpsession->get('cin');
        $cout = $this->phpsession->get('cout');
        $room_num = $this->phpsession->get('room_num');
        $basic_num = $this->phpsession->get('basic_num');
        $child1_num = $this->phpsession->get('child1_num');
        $child2_num = $this->phpsession->get('child2_num');
        $child3_num = $this->phpsession->get('child3_num');
        $child4_num = $this->phpsession->get('child4_num');
        
        // VAR_DUMPは標準出力に出すのでobでバッファに出力する
        ob_start();
        var_dump($_SESSION);
        $dump = ob_get_contents();
        ob_end_clean();
        log_message('info', $dump);
        
        $this->db->where('planid', $planid);
        $query = $this->db->get('plans', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $roomtypeid = $row['roomtypeid'];
            $plan_guest_min = $row['guest_min'];
            $plan_guest_max = $row['guest_max'];
            $basic_count = $row['basic_count'];
            $child1_count = $row['child1_count'];
            $child2_count = $row['child2_count'];
            $child3_count = $row['child3_count'];
            $child4_count = $row['child4_count'];
        }
        else
        {
            return  Res_model::ERR_PARAM;
        }
        
        $this->db->where('roomtypeid', $roomtypeid);
        $query = $this->db->get('roomtypes', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $roomtypeid = $row['roomtypeid'];
            $roomtype_guest_min = $row['guest_min'];
            $roomtype_guest_max = $row['guest_max'];
        }
        else
        {
            return  Res_model::ERR_PARAM;
        }
        
        // 一部屋あたりの人数
        $n = $basic_count * set_value('basic_num')
           + $child1_count * set_value('child1_num')
           + $child2_count * set_value('child2_num')
           + $child3_count * set_value('child3_num')
           + $child4_count * set_value('child4_num');
        
        // 予約プラン人数
        $vplan = $n * set_value('room_num');
        
        // 予約空き部屋数
        $vroom = set_value('room_num');
        
        try
        {
            // roomtype
            
            // 人数が部屋の許容人数以内であることをチェックする
            if ($n < $roomtype_guest_min)
            {
                throw new Exception('',  Res_model::ERR_ROOM_GUEST_MIN);
            }
            else if ($n > $roomtype_guest_max)
            {
                //echo "n=" . $n . "<br />";
                //echo "roomtype_guest_max=" . $roomtype_guest_max . "<br />";
                throw new Exception('',  Res_model::ERR_ROOM_GUEST_MAX);
            }
            
            // プラン人数がプランの許容最小値から最大値の範囲内である
            // ことをチェックする。
            if ($vplan < $plan_guest_min)
            {
                throw new Exception('',  Res_model::ERR_PLAN_GUEST_MIN);
            }
            else if ($vplan > $plan_guest_max)
            {
                log_message('info', 
                    'ERR_PLAN_GUEST_MAX:vplan=' . $vplan .
                    ',plan_guest_max=' . $plan_guest_max);
                throw new Exception('',  Res_model::ERR_PLAN_GUEST_MAX);
            }
            
            $day_price = 0;
            $tmp_y = substr($cin, 0, 4);
            $tmp_m = substr($cin, 5, 2);
            $tmp_d = substr($cin, 8, 2);
            for ($i = 0;;$i++) {
                $tmp_date = date('Y-m-d', mktime(0, 0, 0, $tmp_m, $tmp_d + $i, $tmp_y));
                if ($tmp_date >= $cout) {
                    break;
                }
                
                // プラン人数空きをチェックする。
                $this->db->where('planid', $planid);
                $this->db->where('day', $tmp_date);
                $query = $this->db->get('vacantplans', 1);
                if ($query->num_rows() > 0)
                {
                    $row = $query->row_array();
                    $vp_num = $row['num'];
                    if ($vp_num >= $vplan)
                    {
                    }
                    else
                    {
                        throw new Exception('',  Res_model::ERR_VACANT_PLAN);
                    }
                }
                else
                {
                    throw new Exception('',  Res_model::ERR_VACANT_PLAN);
                }
                
                // 部屋数の空きをチェックする。
                $this->db->where('roomtypeid', $roomtypeid);
                $this->db->where('day', $tmp_date);
                $query = $this->db->get('vacantrooms', 1);
                if ($query->num_rows() > 0)
                {
                    $row = $query->row_array();
                    $vr_num = $row['num'];
                    if ($vr_num >= $vroom)
                    {
                    }
                    else
                    {
                        throw new Exception('',  Res_model::ERR_VACANT_ROOM);
                    }
                }
                else
                {
                    throw new Exception('',  Res_model::ERR_VACANT_ROOM);
                }
                
                // 1日分の料金計算
                $day_price += $this->getDayPrice($planid, $tmp_date, $room_num,
                    $basic_num, $child1_num, $child2_num, $child3_num, $child4_num);
            }
            
            // 総料金をセットする
            $this->phpsession->save('total_price', $day_price);
            
            return 0;
        }
        catch (Exception $e)
        {
            return $e->getCode();
        }
    }
    
    /**
     * 仮予約を実行する
     *
     * セッションの予約データを参照する。
     * @return 0:正常,負数:エラー
     */
    public function doRes($hotel_model)
    {
        $this->load->library('phpsession');
        
        $planid = $this->phpsession->get('planid');
        $cin = $this->phpsession->get('cin');
        $cout = $this->phpsession->get('cout');
        $room_num = $this->phpsession->get('room_num');
        $basic_num = $this->phpsession->get('basic_num');
        $child1_num = $this->phpsession->get('child1_num');
        $child2_num = $this->phpsession->get('child2_num');
        $child3_num = $this->phpsession->get('child3_num');
        $child4_num = $this->phpsession->get('child4_num');
        
        // VAR_DUMPは標準出力に出すのでobでバッファに出力する
        ob_start();
        var_dump($_SESSION);
        $dump = ob_get_contents();
        ob_end_clean();
        log_message('info', $dump);
        
        $this->db->where('planid', $planid);
        $query = $this->db->get('plans', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $roomtypeid = $row['roomtypeid'];
            $plan_guest_min = $row['guest_min'];
            $plan_guest_max = $row['guest_max'];
            $basic_count = $row['basic_count'];
            $child1_count = $row['child1_count'];
            $child2_count = $row['child2_count'];
            $child3_count = $row['child3_count'];
            $child4_count = $row['child4_count'];
        }
        else
        {
            log_message('info', 'doRes check1');
            die();
        }
        
        // 一部屋あたりの人数
        $n = $basic_count  * $basic_num
           + $child1_count * $child1_num
           + $child2_count * $child2_num
           + $child3_count * $child3_num
           + $child4_count * $child4_num;
        
        // 予約プラン人数
        $vplan = $n * $room_num;
        
        // 予約空き部屋数
        $vroom = $room_num;
        
        // トランザクション開始
        $this->db->trans_start();
        
        $day_price = 0;
        try
        {
            $this->lock();
            
            $tmp_y = substr($cin, 0, 4);
            $tmp_m = substr($cin, 5, 2);
            $tmp_d = substr($cin, 8, 2);
            for ($i = 0;;$i++) {
                $tmp_date = date('Y-m-d', mktime(0, 0, 0, $tmp_m, $tmp_d + $i, $tmp_y));
                if ($tmp_date >= $cout) {
                    break;
                }
                
                // プラン人数空きをチェックし、空きがあれば空き数を更新する。
                $this->db->where('planid', $planid);
                $this->db->where('day', $tmp_date);
                $query = $this->db->get('vacantplans', 1);
                if ($query->num_rows() > 0)
                {
                    $row = $query->row_array();
                    $vp_num = $row['num'];
                    if ($vp_num >= $vplan)
                    {
                        $this->db->where('planid', $planid);
                        $this->db->where('day', $tmp_date);
                        $a = array('num' => $vp_num - $vplan);
                        $this->db->update('vacantplans', $a);
                    }
                }
                else
                {
                    log_message('info', 'Res::ERR_VACANT_PLAN');
                    throw new Exception('', Res::ERR_VACANT_PLAN);
                }
                
                // 部屋数の空きをチェックをし、空きがあれば空き数を更新する。
                $this->db->where('roomtypeid', $roomtypeid);
                $this->db->where('day', $tmp_date);
                $query = $this->db->get('vacantrooms', 1);
                if ($query->num_rows() > 0)
                {
                    $row = $query->row_array();
                    $vr_num = $row['num'];
                    if ($vr_num >= $vroom)
                    {
                        $this->db->where('roomtypeid', $roomtypeid);
                        $this->db->where('day', $tmp_date);
                        $a = array('num' => $vr_num - $vroom);
                        $this->db->update('vacantrooms', $a);
                    }
                }
                else
                {
                    log_message('info', 'Res::ERR_VACANT_ROOM');
                    throw new Exception('', Res::ERR_VACANT_ROOM);
                }
                
                // 1日分の料金計算
                $day_price += $this->getDayPrice($planid, $tmp_date, $room_num,
                    $basic_num, $child1_num, $child2_num, $child3_num, $child4_num);
            }
            
            $userid = $this->phpsession->get('userid');
            if ($userid == null)
            {
                $userid = 0;
            }
            
            $rescode = uniqid();
            $data = array(
                           'rescode' => $rescode,
                           'cin' => $cin,
                           'cout' => $cout,
                           'userid' => $userid,
                           'planid' => $planid,
                           'roomtypeid' => $roomtypeid,
                           'plan_num' => $vplan,
                           'room_num' => $vroom,
                           'basic_num' => $basic_num,
                           'child1_num' => $child1_num,
                           'child2_num' => $child2_num,
                           'child3_num' => $child3_num,
                           'child4_num' => $child4_num,
                           'status' => 1,
                           'total_price' => $day_price,
                           'created' => date("Y-m-d H:i:s")
                        );
            $this->db->insert('reservation', $data);
            $resid = $this->db->insert_id();
            
            // log
            log_message('info', 'reservation insert ok');
            
            $data2 = array(
                            'resid' => $resid,
                            'userid' => $userid,
                            'email' => $this->phpsession->get('email'),
                            'name' => $this->phpsession->get('name'),
                            'name_kana' => $this->phpsession->get('name_kana'),
                            'postcode' => $this->phpsession->get('postcode'),
                            'prefecture' => $this->phpsession->get('prefecture'),
                            'city' => $this->phpsession->get('city'),
                            'street' => $this->phpsession->get('street'),
                            'phone' => $this->phpsession->get('phone')
                        );
            $this->db->insert('resuser', $data2);
            
            // log
            log_message('info', 'resuser insert ok');
            
            // トランザクション終了
            $this->db->trans_complete();
            
            log_message('info', 'trans_complete');
            
            /**
             * 完了画面に表示する情報はセッションに保存する。
             * resid, rescode
             */
            $this->phpsession->save('resid', $resid);
            $this->phpsession->save('rescode', $rescode);
            
            $this->unlock();
            
            
            // ユーザ宛仮予約Eメール送信
            
            $num = $data['basic_num']
                 + $data['child1_num']
                 + $data['child2_num']
                 + $data['child3_num']
                 + $data['child4_num'];
            if ($userid == 0)
            {
                $cancel_url = site_url('cancel');
            }
            else
            {
                $cancel_url = site_url('my/index');
            }
            
            $mail_subject = $hotel_model->hotel_name . ": 仮予約メール";
            $mail_body = 
                $data2['name'] . " 様\n" . 
                "この度は、" . $hotel_model->hotel_name . "をご予約いただき、ありがとうございます。\n" . 
                "以下のご予約を承りました。\n" .
                "後ほど、本予約メールをお送りいたします。\n" .
                "(場合によってキャンセルしていただくことがあります。\n" .
                "その際にはキャンセルのメールをお送りします。ご了承ください。)\n" .
                "ご予約内容\n" .
                "---------------------\n" .
                "予約No: " . $data['rescode'] . "\n" .
                "予約受付日: " . $data['created'] . "\n" .
                "チェックイン日時: " . $data['cin'] . "\n" .
                "チェックアウト日: " . $data['cout'] . "\n" .
                "申込者氏名: " . $data2['name'] . "\n" .
                //"プラン名: " . "\n" .
                //"部屋タイプ; " . "\n" .
                "人数: " . $num . "\n" .
                "部屋数: " . $data['room_num'] . "\n" .
                "料金: " . $data['total_price'] . "\n" .
                "\n" .
                "ご予約の確認、キャンセルはこちらから\n" .
                $cancel_url . "\n";
            
            log_message('info', $mail_body);
            
            qd_send_mail(
                'text', 
                $this->phpsession->get('email'),
                $mail_subject,
                $mail_body,
                $hotel_model->email);
            
            // 管理者宛仮予約Eメール送信
            // 件名,本文はユーザ宛と同じ。宛先だけ違う。
            qd_send_mail(
                'text', 
                $hotel_model->email,
                $mail_subject,
                $mail_body,
                $hotel_model->email);
            
            return $resid;
        }
        catch (Exception $e)
        {
            $this->db->trans_rollback();
            
            $this->unlock();
            log_message('info', 'doRes ' . $e->getCode());
            return $e->getCode();
        }
    }
    
    /**
     * 本予約
     */
    public function confirmRes($resid, $hotel_model)
    {
        $this->db->where('resid', $resid);
        $this->db->where('status >', 0);
        $query = $this->db->get('reservation', 1);
        if ($query->num_rows() <= 0)
        {
            return;
        }
        $data = $query->row_array();
        
        $this->db->where('resid', $resid);
        $this->db->update('reservation', array('status' => 2));
        
        $this->db->where('resid', $resid);
        $query = $this->db->get('resuser', 1);
        if ($query->num_rows() <= 0)
        {
            return;
        }
        $data2 = $query->row_array();
        
        // Eメール送信
        
        $num = $data['basic_num']
             + $data['child1_num']
             + $data['child2_num']
             + $data['child3_num']
             + $data['child4_num'];
        
        if ($data['userid'] == 0)
        {
            $cancel_url = site_url('cancel');
        }
        else
        {
            $cancel_url = site_url('my/index');
        }
        
        $mail_subject = $hotel_model->hotel_name . ": 本予約メール";
        $mail_body = 
            $data2['name'] . " 様\n" . 
            "この度は、" . $hotel_model->hotel_name . "をご予約いただき、ありがとうございます。\n" . 
            "以下のご予約を承りました。\n" .
            "お越しをお待ちいたしております。\n" .
            "ご予約内容\n" .
            "---------------------\n" .
            "予約No: " . $data['rescode'] . "\n" .
            "予約受付日: " . $data['created'] . "\n" .
            "チェックイン日時: " . $data['cin'] . "\n" .
            "チェックアウト日: " . $data['cout'] . "\n" .
            "申込者氏名: " . $data2['name'] . "\n" .
            "プラン名: " . "\n" .
            "部屋タイプ; " . "\n" .
            "人数: " . $num . "\n" .
            "部屋数: " . $data['room_num'] . "\n" .
            "料金: " . $data['total_price'] . "\n" .
            "\n" .
            "ご予約の確認、キャンセルはこちらから\n" .
            $cancel_url . "\n";
        
        log_message('info', $mail_subject);
        log_message('info', $mail_body);
        
        /**
         * 本予約メールはユーザにのみ送信する。
         * 管理者は自身で本処理に変更していてわかっているので、
         * 送信しなくて良い。
         */
        qd_send_mail(
            'text', 
            $data2['email'],
            $mail_subject,
            $mail_body,
            $hotel_model->email);
    }
    
    /**
     * 予約キャンセル
     * @param int $resid 予約Id
     * @param int $mode  1:ユーザによるキャンセル
                         2:管理者によるキャンセル(本予約不可)
                         3:本予約取消
     */
    public function cancel($resid, $mode = 1, $hotel_model)
    {
        $this->db->where('resid', $resid);
        $this->db->where('status >', 0);
        $query = $this->db->get('reservation', 1);
        if ($query->num_rows() <= 0)
        {
            return -1;
        }
        
        $row = $query->row_array();
        $rescode = $row['rescode'];
        $planid = $row['planid'];
        $roomtypeid = $row['roomtypeid'];
        $cin = $row['cin'];
        $cout = $row['cout'];
        $room_num = $row['room_num'];
        $plan_num = $row['plan_num'];
        
        $this->db->where('planid', $planid);
        $query = $this->db->get('plans', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $plan_name = $row['roomtypeid'];
        }
        else
        {
            return -2;
        }
        
        $this->db->where('roomtypeid', $roomtypeid);
        $query = $this->db->get('roomtypes', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $roomtype_name = $row['roomtypeid'];
        }
        else
        {
            return -3;
        }
        
        $this->db->trans_start();
        try
        {
            $this->lock();
            
            // 空きを元に戻す
            $tmp_y = substr($cin, 0, 4);
            $tmp_m = substr($cin, 5, 2);
            $tmp_d = substr($cin, 8, 2);
            for ($i = 0;;$i++)
            {
                $tmp_date = date('Y-m-d', mktime(0, 0, 0, $tmp_m, $tmp_d + $i, $tmp_y));
                if ($tmp_date >= $cout) {
                    break;
                }
                
                $this->db->where('planid', $planid);
                $this->db->where('day', $tmp_date);
                $query = $this->db->get('vacantplans', 1);
                if ($query->num_rows() > 0)
                {
                    $row = $query->row_array();
                    $vp_num = $row['num'];
                    $this->db->where('planid', $planid);
                    $this->db->where('day', $tmp_date);
                    $a = array('num' => $vp_num + $plan_num);
                    $this->db->update('vacantplans', $a);
                }
                
                $this->db->where('roomtypeid', $roomtypeid);
                $this->db->where('day', $tmp_date);
                $query = $this->db->get('vacantrooms', 1);
                if ($query->num_rows() > 0)
                {
                    $row = $query->row_array();
                    $vr_num = $row['num'];
                    $this->db->where('roomtypeid', $roomtypeid);
                    $this->db->where('day', $tmp_date);
                    $a = array('num' => $vr_num + $room_num);
                    $this->db->update('vacantrooms', $a);
                }
            }
            
            /**
             * reservationのstatusを0にする
             * resuserは変更しない(そのまま残す)
             */
            $this->db->where('resid', $resid);
            $a = array('status' => 0);
            $this->db->update('reservation', $a);
            
        }
        catch (Exception $ex)
        {
            $this->db->trans_rollback();
            $this->unlock();

            return -10;
        }
        
        $this->db->trans_complete();
        $this->unlock();
        
        $this->db->where('resid', $resid);
        $query = $this->db->get('reservation', 1);
        if ($query->num_rows() <= 0)
        {
            return;
        }
        $data = $query->row_array();
        
        $this->db->where('resid', $resid);
        $query = $this->db->get('resuser', 1);
        if ($query->num_rows() <= 0)
        {
            return;
        }
        $data2 = $query->row_array();
        
        // Eメール送信
        
        $num = $data['basic_num']
             + $data['child1_num']
             + $data['child2_num']
             + $data['child3_num']
             + $data['child4_num'];
        
        $mail_subject = $hotel_model->hotel_name . ": 予約キャンセルメール";
        $mail_body = 
            $data['name'] . " 様\n" . 
            "この度は、" . $hotel_model->hotel_name . "をご利用いただき、ありがとうございます。\n" . 
            "以下のご予約のキャンセルを承りました。\n" .
            "またのご利用をお待ちしております。\n" .
            "ご予約内容\n" .
            "---------------------\n" .
            "予約No: " . $data['rescode'] . "\n" .
            "予約受付日: " . $data['created'] . "\n" .
            "チェックイン日時: " . $data['cin'] . "\n" .
            "チェックアウト日: " . $data['cout'] . "\n" .
            "申込者氏名: " . $data2['name'] . "\n" .
            "プラン名: " . "\n" .
            "部屋タイプ; " . "\n" .
            "人数: " . $num . "\n" .
            "部屋数: " . $data['room_num'] . "\n" .
            "料金: " . $data['total_price'] . "\n" .
            "\n";
        
        log_message('info', $mail_subject);
        log_message('info', $mail_body);
        
        /**
         * キャンセルメールの送信
         */
        qd_send_mail(
            'text', 
            $data2['email'],
            $mail_subject,
            $mail_body,
            $hotel_model->email);
        qd_send_mail(
            'text',
            $hotel_model->email,
            $mail_subject,
            $mail_body,
            $hotel_model->email);
    }
    
    /**
     * 総料金を返す
     * @return 総料金,エラーのとき負数を返す
     */
//    public function getTotalPrice(
//        $planid, $start_date, $end_date, $room_num,
//        $basic_num, $child1_num, $child2_num, $child3_num, $child4_num)
//    {
//        return -1;
//    }
    
    /**
     * 一日分の料金を返す
     */
    public function getDayPrice(
        $planid, $day, $room_num,
        $basic_num, $child1_num, $child2_num, $child3_num, $child4_num)
    {
        $tmp = 0;
        
        // $dayのdayTypeを得る
        $dayType = 'A';
        $this->db->where('day', $day);
        $query = $this->db->get('daytype', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $dayType = $row['value'];
        }
        
        // Planid,dayTypeのユーザ別料金を得る
        $this->db->where('planid', $planid);
        $query = $this->db->get('planprice', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
        }
        else
        {
            log_message('error', __LINE__ . 'doRes planprice error');
            die();
        }
        
        if ($dayType == 'A')
        {
            $tmp = $basic_num  * $row['a_basic_price']
                 + $child1_num * $row['a_child1_price']
                 + $child2_num * $row['a_child2_price']
                 + $child3_num * $row['a_child3_price']
                 + $child4_num * $row['a_child4_price'];
        }
        else if ($dayType == 'B')
        {
            $tmp = $basic_num  * $row['b_basic_price']
                 + $child1_num * $row['b_child1_price']
                 + $child2_num * $row['b_child2_price']
                 + $child3_num * $row['b_child3_price']
                 + $child4_num * $row['b_child4_price'];
        }
        else if ($dayType == 'C')
        {
            $tmp = $basic_num  * $row['c_basic_price']
                 + $child1_num * $row['c_child1_price']
                 + $child2_num * $row['c_child2_price']
                 + $child3_num * $row['c_child3_price']
                 + $child4_num * $row['c_child4_price'];
        }
        else if ($dayType == 'D')
        {
            $tmp = $basic_num  * $row['d_basic_price']
                 + $child1_num * $row['d_child1_price']
                 + $child2_num * $row['d_child2_price']
                 + $child3_num * $row['d_child3_price']
                 + $child4_num * $row['d_child4_price'];
        }
        else
        {
            log_message('error', __LINE__ . 'daytype error');
        }
        return $tmp * $room_num;
    }
}
