<?php
/**
 * Login
 *
 */
class Login extends Controller {

    function Login()
    {
        parent::Controller();
    }
    
    public function index()
    {
        // ログイン処理をし、indexページに戻る。
        $this->load->library('phpsession');
        $this->load->helper(array('form', 'url'));
        $data['title'] = "login";
        $data['headline'] = "";
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('username', 'ユーザ名', 'trim|required|xss_clean');
        $this->form_validation->set_rules('password', 'パスワード', 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('admin/login/index');
        }
        else
        {
            $username = set_value('username');
            $password = set_value('password');
            
            // username, passwordをチェックする
            $this->db->where('username', $username);
            $this->db->where('password', sha1($password));
            $this->db->where('status', 1);
            $query = $this->db->get('admins', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $this->phpsession->save('admin',
                    array('adminid' => $row['adminid'],
                          'username' => $row['username'],
                          'email' => $row['email'],
                          'hotelid' => $row['hotelid']));
                // 最終ログイン日時を更新する
                $data = array('last_login' => date("Y-m-d H:i:s"));
                $this->db->where('adminid', $row['adminid']);
                $this->db->update('admins', $data);
                redirect('admin/res/index/' . $row['hotelid']);
            }
            else
            {
                $data['error'] = array();
                $data['error'][] = 'ユーザ名、またはパスワードが間違っています。';
                $data['error'][] = 'password = ' . sha1($password);
                $this->load->vars($data);
                $this->load->view('admin/login/index');
            }
        }
    }
    
    /**
     * ログアウト
     */
    public function logout()
    {
        $this->load->helper(array('form', 'url'));
        $this->load->library('phpsession');
        
        $this->phpsession->clear('admin');
        redirect('admin/login/index');
    }
}
