<?php
/**
 * Roomtypes Management
 * @package     ci-hotel
 * @author      Teruki Hosokawa <hosotk@gmail.com>
 * @licence     New BSD Licence
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Roomtypes extends ADMIN_Controller {

    function Roomtypes()
    {
        parent::ADMIN_Controller();
        $this->load->model('User_model');
        $this->load->model('Common_model');
    }
    
    /**
     * 部屋タイプ一覧
     */
    public function index($hotelid)
    {
        $this->load->helper(array('form', 'url'));
        //$this->db->order_by('ordering ASC');
        $this->db->where('status', 1);
        $query = $this->db->get('roomtypes');
        $data['roomtypes'] = $query->result_array();
        $this->load->vars($data);
        $this->load->view('admin/roomtypes/index');
    }
    
    /**
     * 部屋タイプの新規作成
     */
    public function add($hotelid)
    {
        $this->load->helper(array('form', 'url'));
        $this->load->helper('ck');
        
        $data['summary'] = '';
        $data['description'] = '';
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        // ruleがないときも空でset_rules()しておく。
        // そうでないとset_value()で値が取れなくなる。
        $this->form_validation->set_rules('roomtype_name', '部屋タイプ名', 'required');
        $this->form_validation->set_rules('summary', '概要', 'required');
        $this->form_validation->set_rules('description', '説明', '');
        $this->form_validation->set_rules('start_date', '開始日付', 'required');
        $this->form_validation->set_rules('end_date', '終了日付', 'required');
        $this->form_validation->set_rules('default_num', 'デフォルト数', 'required');
        $this->form_validation->set_rules('guest_min', '最小人数', 'required');
        $this->form_validation->set_rules('guest_max', '最大人数', 'required');
        
        if (!$this->input->post('submit'))
        {
            $data['default_num'] = 1;
            $data['guest_min'] = 1;
            $data['guest_max'] = 1;
            $this->load->vars($data);
        }
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('admin/roomtypes/add');
        }
        else
        {
            $start_date = set_value('start_date');
            $end_date = set_value('end_date');
            // 日付のチェック
            if ($this->Common_model->checkDate($start_date) == false)
            {
                $data['error'] = array();
                $data['error'][] = '開始日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('admin/roomtypes/add');
                return;
            }
            if ($this->Common_model->checkDate($end_date) == false)
            {
                $data['error'] = array();
                $data['error'][] = '終了日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('admin/roomtypes/add');
                return;
            }
            // 開始日付 < 終了日付
            if ($start_date >= $end_date)
            {
                $data['error'] = array();
                $data['error'][] = '終了日付は開始日付の翌日以降を指定します。';
                $this->load->vars($data);
                $this->load->view('admin/roomtypes/add');
                return;
            }
            // 最小人数 <= 最大人数
            $guest_min = set_value('guest_min');
            $guest_max = set_value('guest_max');
            if ($guest_min > $guest_max)
            {
                $data['error'] = array();
                $data['error'][] = '最大人数は最小人数以上を指定します。';
                $this->load->vars($data);
                $this->load->view('admin/roomtypes/add');
                return;
            }
            
            $data = array(
                           'hotelid' => $hotelid,
                           'roomtype_name' => set_value('roomtype_name'),
                           'summary' => $_POST['summary'],
                           'description' => $_POST['description'],
                           'start_date' => set_value('start_date'),
                           'end_date' => set_value('end_date'),
                           'default_num' => set_value('default_num'),
                           'guest_min' => set_value('guest_min'),
                           'guest_max' => set_value('guest_max'),
                           'status' => 1
                        );
            $this->db->insert('roomtypes', $data);
            
            redirect('admin/roomtypes/index/' . $hotelid);
        }
    }
    
    /**
     * 部屋タイプの編集
     */
    public function edit($hotelid, $roomtypeid)
    {
        $this->load->helper(array('form', 'url'));
        $this->load->helper('ck');
        
        $data['roomtypeid'] = $roomtypeid;
        $data['summary'] = '';
        $data['description'] = '';
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        // ruleがないときも空でset_rules()しておく。
        // そうでないとset_value()で値が取れなくなる。
        $this->form_validation->set_rules('roomtype_name', '部屋タイプ名', 'required');
        $this->form_validation->set_rules('summary', '概要', 'required');
        $this->form_validation->set_rules('description', '説明', '');
        $this->form_validation->set_rules('start_date', '開始日付', 'required');
        $this->form_validation->set_rules('end_date', '終了日時', 'required');
        $this->form_validation->set_rules('default_num', 'デフォルト数', 'required');
        $this->form_validation->set_rules('guest_min', '最小人数', 'required');
        $this->form_validation->set_rules('guest_max', '最大人数', 'required');
        
        // フォームの初期値設定
        if (!$this->input->post('submit'))
        {
            $this->db->where('roomtypeid', $roomtypeid);
            $this->db->where('status', 1);
            $query = $this->db->get('roomtypes', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $data['roomtype_name'] = $row['roomtype_name'];
                $data['summary'] = $row['summary'];
                $data['description'] = $row['description'];
                $data['start_date'] = substr($row['start_date'], 0, 10);
                $data['end_date'] = substr($row['end_date'], 0, 10);
                $data['default_num'] = $row['default_num'];
                $data['guest_min'] = $row['guest_min'];
                $data['guest_max'] = $row['guest_max'];
                $this->load->vars($data);
            }
            else
            {
                die();
            }
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('admin/roomtypes/edit');
        }
        else
        {
            $start_date = set_value('start_date');
            $end_date = set_value('end_date');
            // 日付のチェック
            if ($this->Common_model->checkDate($start_date) == false)
            {
                $data['error'] = array();
                $data['error'][] = '開始日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('admin/plans/edit');
                return;
            }
            if ($this->Common_model->checkDate($end_date) == false)
            {
                $data['error'] = array();
                $data['error'][] = '終了日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('admin/plans/edit');
                return;
            }
            // 開始日付 < 終了日付
            if ($start_date >= $end_date)
            {
                $data['error'] = array();
                $data['error'][] = '終了日付は開始日付の翌日以降を指定します。';
                $this->load->vars($data);
                $this->load->view('admin/plans/edit');
                return;
            }
            // 最小人数 <= 最大人数
            $guest_min = set_value('guest_min');
            $guest_max = set_value('guest_max');
            if ($guest_min > $guest_max)
            {
                $data['error'] = array();
                $data['error'][] = '最大人数は最小人数以上を指定します。';
                $this->load->vars($data);
                $this->load->view('admin/plans/edit');
                return;
            }
            
            /**
             * htmlを含む文字列をset_value()するとhtmlspecialchars()を通した
             * 文字列に変換されてしまうので_POST[]を使う。
             */
            $data = array(
                           'roomtype_name' => set_value('roomtype_name'),
                           'summary' => $_POST['summary'],
                           'description' => $_POST['description'],
                           'start_date' => set_value('start_date'),
                           'end_date' => set_value('end_date'),
                           'default_num' => set_value('default_num'),
                           'guest_min' => set_value('guest_min'),
                           'guest_max' => set_value('guest_max'),
                           'status' => 1
                           //'modified' => date("Y-m-d H：i：s")
                        );

            //log_message('info', '_POST=' . $_POST['summary']);
            //log_message('info', 'set_value=' . set_value('summary'));
            //log_message('info', 'data=' . $data['summary']);
            //log_message('info', '_POST=' . $_POST['description']);
            //log_message('info', 'set_value=' . set_value('description'));
            //log_message('info', 'data=' . $data['description']);

            $this->db->where('roomtypeid', $roomtypeid);
            $this->db->update('roomtypes', $data);
            
            redirect('admin/roomtypes/index/' . $hotelid);
        }
    }
    
    /**
     * 部屋タイプの削除
     */
    public function delete($hotelid, $roomtypeid)
    {
        $data = array('status' => -1);
        $this->db->where('roomtypeid', $roomtypeid);
        $this->db->update('roomtypes', $data);
        
        redirect('admin/roomtypes/index/' . $hotelid);
    }
}

/* End of file roomtypes.php */
