<?php
/**
 * 会員専用ページ
 * 
 */
require_once (dirname(__FILE__) . "/FRONT_Controller.php");

class Mypage extends FRONT_Controller {
    
    private $user = null;
    
    function Mypage()
    {
        parent::FRONT_Controller();
        $this->load->model('Res_model');
        $this->load->model('Hotel_model');
        
        // ログインチェック
        $this->load->helper('url');
        $this->load->library('phpsession');
        $this->member = $this->phpsession->get('member');
        if (is_null($this->member))
        {
            redirect('login/login');
        }
    }
    
    /**
     * 予約リストを表示する
     */
    function index($hotelid)
    {
        $this->load->library('phpsession');
        $this->load->helper(array('form', 'url'));
        
        // ユーザの予約リストを得る
        $this->db->where('memberid', $this->member['memberid']);
        $this->db->where('status >', 0);
        $this->db->order_by('created', 'desc');
        $query = $this->db->get('reservation');
        
        $data['ress'] = $query->result_array();
        $data['title'] = "User Res";
        $data['headline'] = "";
        $this->load->vars($data);
        
        $this->load->view('mypage/index');
    }
    
    /**
     * 予約詳細
     */
    public function resdetail($hotelid, $resid)
    {
        // 予約詳細をみる
        $this->db->where('resid', $resid);
        $query = $this->db->get('reservation');
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
        }
        else
        {
            die();
        }
        $this->load->vars($data);
        
        if ($data['memberid'] != $this->user['memberid'])
        {
            die();
        }
        
        $this->load->view('mypage/resdetail');
    }
    
    /**
     * 予約キャンセル
     */
    public function rescancel($hotelid, $resid)
    {
        // 予約詳細をみる
        $this->db->where('resid', $resid);
        $query = $this->db->get('reservation');
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
            if ($data['memberid'] == $this->member['memberid'])
            {
                $this->Res_model->cancel($resid, 1, $this->Hotel_model);
            }
        }
        else
        {
            die();
        }
    }
    
    /**
     * 会員情報の表示
     */
    public function memberinfo($hotelid)
    {
        $this->db->where('memberid', $this->member['memberid']);
        $query = $this->db->get('members');
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
            $this->load->vars($data);
        }
        $this->load->view('mypage/memberinfo');
    }
    
    /**
     * 会員情報の編集
     */
    public function memberedit($hotelid)
    {
        $this->load->helper(array('form', 'url'));
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('email', 'メールアドレス', 'required|valid_email|trim|xss_clean');
        $this->form_validation->set_rules('password', 'パスワード', 'trim|xss_clean');
        $this->form_validation->set_rules('name', '氏名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('name_kana', '氏名(かな)', 'required|trim|xss_clean|callback_hiragana_check');
        $this->form_validation->set_rules('postcode', '郵便番号', 'required|trim|xss_clean|callback_postcode_check');
        $this->form_validation->set_rules('prefecture', '都道府県', 'required|trim|xss_clean');
        $this->form_validation->set_rules('city', '市区町村', 'required|trim|xss_clean');
        $this->form_validation->set_rules('street', '番地', 'required|trim|xss_clean');
        $this->form_validation->set_rules('phone', '電話番号', 'required|trim|xss_clean|callback_phone_check');
        
        if (!$this->input->post('submit'))
        {
            $this->db->where('memberid', $this->member['memberid']);
            $query = $this->db->get('members', 1);
            if ($query->num_rows() > 0)
            {
                $data = $query->row_array();
                $data['password'] = '';
                $this->load->vars($data);
            }
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            //echo "Form First Or NG";
            $this->load->view('mypage/memberedit');
        }
        else
        {
            // 同じEメールアドレスが登録済みでないことをチェックする
            $this->db->where('email', set_value('email'));
            $this->db->where('hotelid', $hotelid);                          // 同じホテル
            $this->db->where('memberid <> ', $this->member['memberid']);    // 自分以外
            $this->db->where('status > ', 0);
            $query = $this->db->get('members', 1);
            if ($query->num_rows() > 0)
            {
                $data['error'] = array();
                $data['error'][] = '同じEメールアドレスがすでに登録されています。';
                $this->load->vars($data);
                $this->load->view('mypage/memberedit');
                return;
            }
            
            $data = array(
                           'email' => set_value('email'),
                           'password' => sha1(set_value('password')),
                           'name' => set_value('name'),
                           'name_kana' => set_value('name_kana'),
                           'postcode' => set_value('postcode'),
                           'prefecture' => set_value('prefecture'),
                           'city' => set_value('city'),
                           'street' => set_value('street'),
                           'phone' => set_value('phone')
                        );
            $this->db->where('memberid', $this->member['memberid']);
            $this->db->update('members', $data);
            
            if (set_value('password') != '')
            {
                $data = array('password' => sha1(set_value('password')));
                $this->db->where('memberid', $this->user['memberid']);
                $this->db->update('members', $data);
            }
        }
        
        $this->load->view('mypage/memberedit');
    }
    
    /**
     * 退会
     */
    public function unregister($hotelid)
    {
        $data = array('status' => -1);
        $this->db->where('memberid', $this->member['memberid']);
        $this->db->update('members', $data);
        
        // ログアウト処理
        $this->load->library('phpsession');
        $this->phpsession->clear('user');
        
        $this->load->view('mypage/unregister');
    }
}
