<?php
/**
 * Hotel Management
 *
 */
require_once (dirname(__FILE__) . "/SUPER_Controller.php");

class Hotels extends SUPER_Controller {

    function Hotels()
    {
        parent::SUPER_Controller();
        $this->load->model('Common_model');
    }
    
    public function index()
    {
        $this->load->helper(array('form', 'url'));
        redirect('super/hotels/page/');
    }
    
    /**
     * 
     */
    public function page($offset = 0)
    {
        $this->load->helper(array('form', 'url'));
        $limit = 20;    // 1y[W\
        //$this->db->order_by('ordering ASC');
        $this->db->where('status >=', 0);
        $this->db->limit($limit, $offset);
        $query = $this->db->get('hotels');
        $data['hotels'] = $query->result_array();
        
        $this->load->library('session');
        $this->load->library('pagination');
        
        // R[h̎擾
        $this->db->where('status >=', 0);
        $query = $this->db->get('hotels');
        $total_rows = $query->num_rows();
        
        $pager_config['uri_segment'] = 4;
        $pager_config['base_url'] = base_url() . 'super/hotels/page/';
        $pager_config['total_rows'] = $total_rows;
        $pager_config['per_page'] = $limit;
        
        $this->pagination->initialize($pager_config);
        
        $data['links'] = $this->pagination->create_links();
        
        $this->load->vars($data);
        
        $this->load->view('super/hotels/page');
    }
    
    
    public function add()
    {
        $this->load->helper(array('form', 'url'));
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('hotel_name', 'ze', 'required|trim|xss_clean');
        $this->form_validation->set_rules('status', 'Xe[^X', 'required|trim|xss_clean');
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('super/hotels/add');
            return;
        }
        else
        {
            $data = array(
                'hotel_name' => set_value('hotel_name'),
                'status' => set_value('status'));
            $this->db->insert('hotels', $data);
            redirect('super/hotels/index');
        }
        
        $this->load->view('super/hotels/add');
    }
    
    public function edit($hotelid)
    {
        $this->load->helper(array('form', 'url'));
        
        $data['hotelid'] = $hotelid;
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('hotel_name', 'ze', 'required|trim|xss_clean');
        $this->form_validation->set_rules('status', 'Xe[^X', 'required|trim|xss_clean');
        
        if (!$this->input->post('submit'))
        {
            $this->db->where('hotelid', $hotelid);
            $query = $this->db->get('hotels', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $data['hotel_name'] = $row['hotel_name'];
                $data['status'] = $row['status'];
                $this->load->vars($data);
            }
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('super/hotels/edit');
            return;
        }
        else
        {
            $data = array(
                'hotel_name' => set_value('hotel_name'),
                'status' => set_value('status'));
            $this->db->where('hotelid', $hotelid);
            $this->db->update('hotels', $data);
            redirect('super/hotels/index');
        }
        
        $this->load->view('super/hotels/edit');
    }
    
    public function delete($hotelid)
    {
        $this->load->helper(array('form', 'url'));
        
        $data = array('status' => -1);
        $this->db->where('hotelid', $hotelid);
        $this->db->update('hotels', $data);
        redirect('super/hotels/index');
    }
}
/* End of file hotels.php */
