<?php
/**
 * Supers Management
 *
 */
require_once (dirname(__FILE__) . "/SUPER_Controller.php");

class Supers extends SUPER_Controller {

    function Supers()
    {
        parent::SUPER_Controller();
        $this->load->model('User_model');
        $this->load->library('session');
    }
    
    /**
     * システム管理者リスト
     */
    public function index()
    {
        $this->load->helper(array('form', 'url'));
        
        $this->db->where('status >', 0);
        $query = $this->db->get('supers');
        $data['supers'] = $query->result_array();
        
        // 総レコード数の取得
        $this->db->where('status >', 0);
        $query = $this->db->get('supers');
        
        $this->load->vars($data);
        
        $this->load->view('super/supers/index');
    }
    
    /**
     * システム管理者の編集
     */
    public function edit($superid)
    {
        $this->load->helper(array('form', 'url'));
        
        $this->db->where('status', 1);
        
        $data['superid'] = $superid;
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('username', 'ユーザ名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('password', 'パスワード', 'trim|xss_clean');
        
        if (!$this->input->post('submit'))
        {
            $this->db->where('superid', $superid);
            $this->db->where('status > ', 0);
            $query = $this->db->get('supers', 1);
            
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $data['username'] = $row['username'];
                $data['password'] = '';
                $this->load->vars($data);
            }
        }
        
        if ($this->form_validation->run() == false)
        {
            $this->load->view('super/supers/edit');
            return;
        }
        else
        {
            // 同じユーザ名がないことをチェックする
            $this->db->where('username', set_value('username'));
            $this->db->where('superid <> ', $superid);    // 自分以外
            $this->db->where('status > ', 0);
            $query = $this->db->get('supers', 1);
            if ($query->num_rows() > 0)
            {
                $data['error'] = array();
                $data['error'][] = '同じユーザ名がすでに登録されています。他のユーザ名を設定してください。';
                $this->load->vars($data);
                $this->load->view('super/supers/edit');
                return;
            }
            
            if (set_value('password') != '')
            {
                $data = array(
                    'username' => set_value('username'),
                    'password' => sha1(set_value('password')));
            }
            else
            {
                // パスワード入力がないときはパスワードを変更しない。
                $data = array(
                    'username' => set_value('username'));
            }
            $this->db->where('superid', $superid);
            $this->db->update('supers', $data);
            redirect('super/supers/index');
        }
        
        $this->load->view('super/supers/edit');
    }
}
